% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abco.R
\name{t_sampleLogVolMu}
\alias{t_sampleLogVolMu}
\title{Sample the TAR(1) unconditional means}
\usage{
t_sampleLogVolMu(
  h,
  h_mu,
  h_phi,
  h_phi2,
  h_sigma_eta_t,
  h_sigma_eta_0,
  h_st,
  h_log_scale = 0
)
}
\arguments{
\item{h}{the \code{T} vector of log-volatilities}

\item{h_mu}{the \code{1} vector of previous means}

\item{h_phi}{the \code{1} vector of AR(1) coefficient(s)}

\item{h_phi2}{the \code{1} vector of previous penalty coefficient(s)}

\item{h_sigma_eta_t}{the \code{T} vector of log-vol innovation standard deviations}

\item{h_sigma_eta_0}{the standard deviations of initial log-vols}

\item{h_st}{the \code{T} vector of indicators on whether each time-step exceed the estimated threshold}

\item{h_log_scale}{prior mean from scale mixture of Gaussian (Polya-Gamma) prior, e.g. log(sigma_e^2) or dhs_mean0}
}
\value{
the sampled mean(s) \code{dhs_mean}
}
\description{
Compute one draw of the unconditional means in an TAR(1) model with Gaussian innovations
and time-dependent innovation variances. In particular, we use the sampler for the
log-volatility TAR(1) process with the parameter-expanded Polya-Gamma sampler. The sampler also applies
to a multivariate case with independent components.
}
