% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/component_samplers.R
\name{sampleBTF_bspline}
\alias{sampleBTF_bspline}
\title{Sampler for first or second order random walk (RW) Gaussian dynamic linear model (DLM)}
\usage{
sampleBTF_bspline(
  y,
  X,
  obs_sigma2,
  evol_sigma_t2,
  XtX_bands,
  Xty = NULL,
  D = 1
)
}
\arguments{
\item{y}{the \code{T x 1} vector of time series observations}

\item{X}{the \code{T x p} basis matrix}

\item{obs_sigma2}{the scalar observation error variance}

\item{evol_sigma_t2}{the \code{p x 1} vector of evolution error variances}

\item{XtX_bands}{list with 4 vectors consisting of the 4-bands of XtX = crossprod(X) (one-time cost)}

\item{Xty}{the \code{p x 1} matrix crossprod(X,y), which is a one-time cost (assuming no missing entries in y)}

\item{D}{the degree of differencing (zero, one, or two)}
}
\value{
\code{p x 1} vector of simulated basis coefficients \code{beta}
}
\description{
Compute one draw of the \code{p x 1} B-spline basis coefficients \code{beta} in a DLM using
back-band substitution methods. The coefficients are penalized with a prior on the D = 0, D = 1, or
D = 2 differences. This model is equivalent to the Bayesian trend filtering (BTF) model
applied to \code{p x 1} vector of equally-spaced B-spline coefficients, with the basis matrix
serving as a design matrix in the observation equation.
}
\note{
Missing entries (NAs) are not permitted in \code{y}. Imputation schemes are available.
}
