% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tukey.R
\name{random.Tukey}
\alias{random.Tukey}
\title{Draw a random sample from a Tukey distribution}
\usage{
\method{random}{Tukey}(x, n = 1L, drop = TRUE, ...)
}
\arguments{
\item{x}{A \code{Tukey} object created by a call to \code{\link[=Tukey]{Tukey()}}.}

\item{n}{The number of samples to draw. Defaults to \code{1L}.}

\item{drop}{logical. Should the result be simplified to a vector if possible?}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
In case of a single distribution object or \code{n = 1}, either a numeric
vector of length \code{n} (if \code{drop = TRUE}, default) or a \code{matrix} with \code{n} columns
(if \code{drop = FALSE}).
}
\description{
Draw a random sample from a Tukey distribution
}
\examples{

set.seed(27)

X <- Tukey(4L, 16L, 2L)
X

cdf(X, 4)
quantile(X, 0.7)
}
