% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{desc_table}
\alias{desc_table}
\alias{desc_table.default}
\alias{desc_table.data.frame}
\alias{desc_table.grouped_df}
\title{Generate a statistics table}
\usage{
desc_table(data, ..., .auto, .labels)

\method{desc_table}{default}(data, ..., .auto, .labels)

\method{desc_table}{data.frame}(data, ..., .labels = NULL, .auto = stats_auto)

\method{desc_table}{grouped_df}(data, ..., .auto = stats_auto, .labels = NULL)
}
\arguments{
\item{data}{The dataframe to analyze}

\item{...}{A list of named statistics to apply to each element of the dataframe, or a function returning a list of named statistics}

\item{.auto}{A function to automatically determine appropriate statistics}

\item{.labels}{A named character vector of variable labels}
}
\value{
A simple or grouped descriptive table
}
\description{
Generate a statistics table with the chosen statistical functions, nested if called with a grouped dataframe.
}
\section{Stats}{

The statistical functions to use in the table are passed as additional arguments.
If the argument is named (eg. \code{N = length}) the name will be used as the column title instead of the function
name (here, \strong{N} instead of \strong{length}).

Any R function can be a statistical function, as long as it returns only one value when applied to a vector, or as
many values as there are levels in a factor, plus one.

Users can also use \code{purrr::map}-like formulas as quick anonymous functions (eg. \code{Q1 = ~ quantile(., .25)} to get the first quantile in a
column named \strong{Q1})

If no statistical function is given to \code{desc_table}, the \code{.auto} argument is used to provide a function
that automatically determines the most appropriate statistical functions to use based on the contents of the table.
}

\section{Labels}{

\code{.labels} is a named character vector to provide "pretty" labels to variables.

If given, the variable names for which there is a label will be replaced by their corresponding label.

Not all variables need to have a label, and labels for non-existing variables are ignored.

labels must be given in the form \code{c(unquoted_variable_name = "label")}
}

\section{Output}{

The output is either a dataframe in the case of a simple descriptive table,
or nested dataframes in the case of a comparative table.
}

\examples{
iris \%>\%
  desc_table()

# Does the same as stats_auto here
iris \%>\%
  desc_table("N"      = length,
             "Min"    = min,
             "Q1"     = ~quantile(., .25),
             "Med"    = median,
             "Mean"   = mean,
             "Q3"     = ~quantile(., .75),
             "Max"    = max,
             "sd"     = sd,
             "IQR"    = IQR)

# With grouping on a factor
iris \%>\%
  group_by(Species) \%>\%
  desc_table(.auto = stats_auto)
}
\seealso{
\code{\link{stats_auto}}

\code{\link{IQR}}

\code{\link{percent}}

Other desc_table core functions: 
\code{\link{desc_output}()},
\code{\link{desc_tests}()}
}
\concept{desc_table core functions}
