% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descsuppR-package.r
\name{descrSurvEstimate}
\alias{descrSurvEstimate}
\title{descrSurvEstimate}
\usage{
descrSurvEstimate(
  S,
  strata,
  stratorder,
  survname = "survival time",
  evaltimes = c(3, 5),
  evaltimeunits = "years",
  digits = 2,
  includeNAs = TRUE,
  includeNonNAs = TRUE,
  missingName = "missing",
  nonNAsName = "N",
  stratheader = TRUE,
  pval = FALSE,
  pvals_formatting = TRUE,
  pvals_digits = 2,
  pvals_signiflev = 0.05,
  hr = FALSE
)
}
\arguments{
\item{S}{survival objects from \code{\link[survival]{Surv}}}

\item{strata}{a list of vectors containing strata.  If the vectors are ordered factors the columns will be used in the given order.}

\item{stratorder}{(list of) character vector for the order of the reported columns.  Overrides any order of strata}

\item{survname}{the name of the survival time, e.g. 'DFS'}

\item{evaltimes}{numeric vector.  for which times to calculate the survival estimate}

\item{evaltimeunits}{the unit of the survival times (years, months, ...)}

\item{digits}{round to}

\item{includeNAs}{boolean.  Include number of NAs in the output?}

\item{includeNonNAs}{Logical; if \code{TRUE}, include a column reporting the number of non-missing (non-NA) observations in the output table. Default is \code{TRUE}.}

\item{missingName}{character.  name of the rows with missing numbers.  Defaults to "missing".}

\item{nonNAsName}{Character string; the name to use as the column heading for the number of non-missing (non-NA) values. Default is \code{"N"}.}

\item{stratheader}{boolean.  print the stratheader?  Turn off for inclusion into a bigger table}

\item{pval}{boolean.  if TRUE, the p value from a cox model is printed in a separate column}

\item{pvals_formatting}{boolean.  If FALSE report numbers, else report formatted strings (via prettyPvalue)}

\item{pvals_digits}{integer.  Number of digits for p value formatting.  Ignored when pvals_formatting==FALSE.  Defaults to 2}

\item{pvals_signiflev}{double.  The significance level for bold p value formatting.  Ignored when pvals_formatting==FALSE.  Defaults to 0.05}

\item{hr}{boolean.  if TRUE, the hazard ratio (with confidence interval) is printed as well.  (only has an effect if pval==TRUE)}
}
\value{
a character matrix
}
\description{
build a description table for survival estimates
}
\details{
calculate the survival estimates at the specified times and return a
nicely formatted table
}
\examples{
if (require("survival")) {

  S <- Surv(aml$time, aml$status)

  descrSurvEstimate(S,
                    evaltimes=c(19, 24),
                    evaltimeunits="months")
}
}
\author{
Andreas Leha
}
