# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Extract the counters from a DEFM model
#'
#' Counters are functions that are defined in terms of the change statistics.
#' The counters also contain a hasher that is used internally to check whether
#' an array's support is cached or not (see details).
#' @details
#' If the hash of an array--which are built using each counters' individual
#' hashing functions--matches an existing array, then, the DEFM models reduce
#' computational burden by recycling computations of the normalizing constant.
#' For example, if a model only includes terms (counters) that do not feature
#' individual-level characteristics like gender or age, then most likely all
#' arrays in that model will use the same normalizing constant.
#' @param model An object of class [DEFM].
#' @returns
#' - The function `get_counters` returns an external pointer to an object of 
#' class `DEFM_counters`.
#' @export
#' @name get_counters
get_counters <- function(model) {
    .Call(`_defm_get_counters_cpp`, model)
}

print_defm_counters <- function(x) {
    invisible(.Call(`_defm_print_counters_cpp`, x))
}

#' @export
#' @rdname get_counters
#' @param counters An object of class `DEFM_counters`.
#' @param i Integer from 0 to nterms - 1. Counter to get.
#' @returns
#' - The method `[.DEFM_counters` returns an individual counter of class
#' `DEFM_counter`.
`[.DEFM_counters` <- function(counters, i) {
    .Call(`_defm_get_counter_cpp`, counters, i)
}

print_defm_counter <- function(x) {
    invisible(.Call(`_defm_print_counter_cpp`, x))
}

#' @export
#' @rdname get_counters
#' @param counter An object of class `DEFM_counter`.
#' @param new_name,new_desc Strings with the new name and new description, 
#' respectively. If empty, no side effect.
#' @details
#' The function `set_counter_info()` can be used to modify a counter name
#' and description. This is especially useful when a name is particularly
#' long.
#' @returns
#' - `set_counter_info()` invisibly returns the modified counter.
set_counter_info <- function(counter, new_name = "", new_desc = "") {
    invisible(.Call(`_defm_set_counter_info_cpp`, counter, new_name, new_desc))
}

as_list_defm_counter <- function(x) {
    .Call(`_defm_as_list_defm_counter_cpp`, x)
}

#' @export
#' @rdname get_counters
#' @returns
#' - The `length` method for `DEFM_counters` returns the number of counters
#' in the vector. This should match the return from [nterms_defm()].
length.DEFM_counters <- function(x) {
    .Call(`_defm_length_defm_counters`, x)
}

#' Discrete Exponential Family Model (DEFM)
#'
#' Discrete Exponential Family Models (DEFMs) are models from the exponential
#' family that deal with discrete data. Here, we deal with binary arrays which
#' can be used to represent, among other things, networks and multinomial binary
#' Markov processes.
#'
#' @param id Integer vector of length `n`. Observation ids, for example, person id.
#' @param Y 0/1 matrix of responses of `n_y` columns and `n` rows.
#' @param X Numeric matrix of covariates of size `n_x` by `n`.
#' @param order Integer. Order of the markov process, by default, 1.
#' @param copy_data Logical scalar. When `TRUE` (default) will copy the data
#' into the model, otherwise it will use the data as a pointer (see details).
#'
#' @details
#' The `id` vector is used to group the observations. For example, if you have
#' a dataset with multiple individuals, the `id` vector should contain the
#' individual ids. The `Y` matrix contains the binary responses, where each
#' column represents a different response variable. The `X` matrix contains
#' the covariates, which can be used to model the relationship between the
#' responses and the covariates. The `order` parameter specifies the order of
#' the Markov process, which determines how many previous observations are
#' used to predict the current observation.
#'
#' The `copy_data` parameter specifies
#' whether the data should be copied into the model or used as a pointer. If
#' `copy_data` is `TRUE`, the data will be copied into the model, which can
#' be useful if you want to avoid duplicating the data in memory. If 
#' `copy_data` is `FALSE`, the model will use the data as a pointer, which can 
#' be more efficient (but dangerous if the data is removed).
#' @return An external pointer of class `DEFM.`
#'
#' @name DEFM
#' @aliases new_defm defm
#' @examples
#' # Loading Valente's SNS data
#' data(valentesnsList)
#' 
#' mymodel <- new_defm(
#'   id = valentesnsList$id,
#'   Y = valentesnsList$Y,
#'   X = valentesnsList$X,
#'   order = 1
#' )
#' 
#' # Adding the intercept terms and a motif from tobacco to mj
#' td_logit_intercept(mymodel)
#' td_formula(mymodel, "{y1, 0y2} > {y1, y2}")
#' 
#' # Initialize the model
#' init_defm(mymodel)
#' 
#' # Fitting the MLE
#' defm_mle(mymodel)
#' 
new_defm_cpp <- function(id, Y, X, order = 1L, copy_data = TRUE) {
    .Call(`_defm_new_defm`, id, Y, X, order, copy_data)
}

set_names <- function(m, ynames, xnames) {
    invisible(.Call(`_defm_set_names`, m, ynames, xnames))
}

#' Access to the names of a model's datasets
#'
#' Retrieve the column names of the dependent variable (`y`) and independent
#' variable (`x`) of an object of class [DEFM].
#'
#' @param m An object of class [DEFM].
#' @name defm-names
#' @returns A character vector.
#' @export
#' @return A character vector with the names of the dependent or independent
#' variables.
#' @examples
#' #' Using Valente's SNS data
#' data(valentesnsList)
#' 
#' # Creating the DEFM object
#' mymodel <- new_defm(
#'   id = valentesnsList$id,
#'   X = valentesnsList$X,
#'   Y = valentesnsList$Y,
#'   order = 0
#' )
#' 
#' # Getting the names
#' get_X_names(mymodel)
#' get_Y_names(mymodel)
get_Y_names <- function(m) {
    .Call(`_defm_get_Y_names`, m)
}

#' @rdname defm-names
#' @export
get_X_names <- function(m) {
    .Call(`_defm_get_X_names`, m)
}

#' @rdname DEFM
#' @param m An object of class `DEFM`.
#' @param force_new Logical scalar. When `TRUE` (default) no cache is used
#' to add new arrays (see details).
#' @details
#' The `init_defm` function initializes the model, which means it computes
#' the sufficient statistics and prepares the model for fitting. The 
#' `force_new` parameter specifies whether to force the model to be 
#' consider each array added as completely unique, even if it has the
#' same support set as an existing array. This is an experimental feature
#' and should be used with caution.  
#' @export
init_defm <- function(m, force_new = FALSE) {
    invisible(.Call(`_defm_init_defm`, m, force_new))
}

print_defm_cpp <- function(x) {
    invisible(.Call(`_defm_print_defm`, x))
}

#' Log-Likelihood of DEFM
#'
#' @param m An object of class [DEFM]
#' @param par A vector of parameters of length `nterms_defm(m)`.
#' @param as_log Logical scalar. When `TRUE` (default) returns the log-likelihood,
#' otherwise it returns the likelihood.
#' @return
#' Numeric, the computed likelihood or log-likelihood of the model.
#' @export
#' @examples
#' # Loading Valtente's SNS data
#' data(valentesnsList)
#' 
#' mymodel <- new_defm(
#'   id    = valentesnsList$id,
#'   Y     = valentesnsList$Y,
#'   X     = valentesnsList$X,
#'   order = 1
#' )
#' 
#' # Adding the intercept terms and a motif from tobacco to mj
#' td_logit_intercept(mymodel)
#' td_formula(mymodel, "{y1, 0y2} > {y1, y2}")
#'
#' # Computing the log-likelihood
#' loglike_defm(mymodel, par = c(-1, -1, -1, 2), as_log = TRUE)
loglike_defm <- function(m, par, as_log = TRUE) {
    .Call(`_defm_loglike_defm`, m, par, as_log)
}

#' Simulate data using a DEFM
#'
#' @param m An object of class [DEFM]. The baseline model.
#' @param par Numeric vector of model parameters.
#' @param fill_t0 Logical scalar. When `TRUE` (default) will fill-in the baseline
#' value of each observation (i.e., the starting condition) (see details.)
#'
#' @details
#' Each observation in the simulation must have initial condition. In practice,
#' this means we start the markov process with a matrix of size
#' `morder_defm(m) x ncol_defm_y(m)`, i.e., order of the Markov process times
#' the number of output variables. when `fill_t0 = TRUE`, the function return
#' the rows corresponding to baseline states with the original value, otherwise
#' it replaces them with -1. This option is mostly for testing purposes.
#'
#' @returns An integer vector of size `nrows_defm(m) x ncol_defm_y(m)`.
#' @export
sim_defm <- function(m, par, fill_t0 = TRUE) {
    .Call(`_defm_sim_defm`, m, par, fill_t0)
}

#' @export
#' @rdname DEFM
#' @param i An integer scalar indicating which set of statistics to print (see details.)
#' @details
#' The `print_stats` function prints the supportset of the ith type
#' of array in the model.
print_stats <- function(m, i = 0L) {
    invisible(.Call(`_defm_print_stats`, m, i))
}

#' @export
#' @rdname DEFM
#' @returns - `nterms_defm` returns the number of terms in the model.
nterms_defm <- function(m) {
    .Call(`_defm_nterms_defm`, m)
}

#' @export
names.DEFM <- function(x) {
    .Call(`_defm_names_defm`, x)
}

#' @export
#' @rdname DEFM
#' @returns - `nrow_defm` returns the number of rows in the model.
nrow_defm <- function(m) {
    .Call(`_defm_nrow_defm`, m)
}

#' @export
#' @rdname DEFM
#' @returns - `ncol_defm_y` returns the number of output variables in 
#' the model.
ncol_defm_y <- function(m) {
    .Call(`_defm_ncol_defm_y`, m)
}

#' @export
#' @rdname DEFM
#' @returns - `ncol_defm_x` returns the number of covariates in the model.
ncol_defm_x <- function(m) {
    .Call(`_defm_ncol_defm_x`, m)
}

#' @export
#' @rdname DEFM
#' @returns - `nobs_defm` returns the number of observations (events) in the
#' model.
nobs_defm <- function(m) {
    .Call(`_defm_nobs_defm`, m)
}

#' @export
#' @rdname DEFM
#' @returns - `morder_defm` returns the order of the Markov process.
morder_defm <- function(m) {
    .Call(`_defm_morder_defm`, m)
}

#' Get sufficient statistics counts
#' 
#' This function computes the individual counts of the sufficient statistics
#' included in the model. 
#' @param m An object of class [DEFM].
#' @export
#' @return A matrix with the counts of the sufficient statistics.
#' @examples
#' data(valentesnsList)
#' 
#' mymodel <- new_defm(
#'   id = valentesnsList$id,
#'   Y = valentesnsList$Y,
#'   X = valentesnsList$X,
#'   order = 1
#' )
#' 
#' # Adding the intercept terms and a motif from tobacco to mj
#' td_logit_intercept(mymodel)
#' td_formula(mymodel, "{y1, 0y2} > {y1, y2}")
#' 
#' # Initialize the model
#' init_defm(mymodel)
#' 
#' # Get the counts
#' head(get_stats(mymodel))
get_stats <- function(m) {
    .Call(`_defm_get_stats`, m)
}

motif_census_cpp <- function(m, locs) {
    .Call(`_defm_motif_census_cpp`, m, locs)
}

#' @param i,j The row and column of the array to turn on for the log odds.
#' @param par The parameters of the model.
#' @param m An object of class [DEFM].
#' @return - `logodds` returns a numeric vector with the log-odds for each observation in the data.
#' @rdname defm_mle
#' @export
logodds <- function(m, par, i, j) {
    .Call(`_defm_logodds`, m, par, i, j)
}

is_motif <- function(m) {
    .Call(`_defm_is_motif`, m)
}

#' Model specification for DEFM
#'
#' @param m An object of class [DEFM].
#' @param covar String. Name of a covariate to use as an interaction
#' for the effect. If equal to `""`, then no interaction effect.
#' is used.
#' used to weight the term.
#' @export
#'
#' @returns Invisible 0.
#'
#' @name defm_terms
#' @aliases terms_defm
#' @examples
#' # Loading Valtente's SNS data
#' data(valentesnsList)
#' 
#' mymodel <- new_defm(
#'   id    = valentesnsList$id,
#'   Y     = valentesnsList$Y,
#'   X     = valentesnsList$X,
#'   order = 1
#' )
#' 
#' # Conventional regression intercept
#' td_logit_intercept(mymodel)
#'
#' # Interaction effect with Hispanic
#' td_logit_intercept(mymodel, covar = "Hispanic")
#' 
#' # Transition effect from only y1 to both equal to 1.
#' td_formula(mymodel, "{y1, 0y2} > {y1, y2}")
#' 
#' # Same but interaction with Female
#' td_formula(mymodel, "{y1, 0y2} > {y1, y2} x Female")
#'
#' # Inspecting the model
#' mymodel
#' 
#' # Initializing and fitting
#' init_defm(mymodel)
#' defm_mle(mymodel)
td_ones <- function(m, covar = "") {
    invisible(.Call(`_defm_td_ones`, m, covar))
}

#' @param mat Integer matrix. The matrix specifies the type of motif to capture
#' (see details.)
#' @details
#' In `td_generic`, users can specify a particular motif to model. Motifs
#' are represented by cells with values equal to 1, for example, the matrix:
#'
#' ```  y0 y1 y2
#' t0:   1 NA NA
#' t1:   1  1 NA
#' ```
#'
#' represents a transition `y0 -> (y1, y2)`. If 0 is a motif of interest, then
#' the matrix should include 0 to mark zero values.
#' @export
#' @rdname defm_terms
td_generic <- function(m, mat, covar = "") {
    invisible(.Call(`_defm_td_generic`, m, mat, covar))
}

#' @details The function `td_formula`,
#' will take the formula and generate the corresponding
#' input for defm::counter_transition(). Formulas can be specified in the
#' following ways:
#'
#' - Intercept effect: `{...}` No transition, only including the current state.
#' - Transition effect: `{...} > {...}` Includes current and previous states.
#'
#' The general notation is `[0]y[column id]_[row id]`. A preceeding zero
#' means that the value of the cell is considered to be zero. The column
#' id goes between 0 and the number of columns in the array - 1 (so it
#' is indexed from 0,) and the row id goes from 0 to m_order.
#'
#' Both Intercepts and Transition can interact with covariates. Using 
#' either the `covar` argument or, in the case of formulas, `x [Covar name]`,
#' for example:
#'
#' - Intercept effect: `{...} x Hispanic` interacts with the Hispanic covar.
#' - Transition effect: `{...} > {...} x Hispanic` Same.
#'
#' ## Intercept effects
#'
#' Intercept effects only involve a single set of curly brackets. Using the
#' 'greater-than' symbol (i.e., `<`) is only for transition effects. When
#' specifying intercept effects, users can skip the `row_id`, e.g.,
#' `y0_0` is equivalent to `y0`. If the passed `row id` is different from
#' the Markov order, i.e., `row_id != m_order`, then the function returns
#' with an error.
#'
#' Examples:
#'
#' - `"{y0, 0y1}"` is equivalent to set a motif with the first element equal
#' to one and the second to zero.
#'
#' ## Transition effects
#'
#' Transition effects can be specified using two sets of curly brackets and
#' an greater-than symbol, i.e., `{...} > {...}`. The first set of brackets,
#' which we call LHS, can only hold `row id` that are less than `m_order`.
#' @param formula Character scalar (see details).
#' @param new_name Character scalar. Name to be assigned for the new term.
#' if empty, then it builds a name based on the formula.
#' @export
#' @rdname defm_terms
td_formula <- function(m, formula, new_name = "") {
    invisible(.Call(`_defm_td_formula`, m, formula, new_name))
}

#' @export
#' @rdname defm_terms
#' @details The term `td_logit_intercept` will add what is equivalent to an
#' intercept in a logistic regression. When `y_indices` is specified, then the
#' function will add one intercept per outcome. These can be weighted by
#' a covariate.
#' @param y_indices Integer vector with the coordinates to include in the term.
td_logit_intercept <- function(m, y_indices = as.integer( c()), covar = "") {
    invisible(.Call(`_defm_td_logit_intercept`, m, y_indices, covar))
}

#' @details The function `rule_not_one_to_zero` will avoid the transition one to zero in a Markov process.
#' @export
#' @rdname defm_terms
#' @param term_indices Non-negative vector of indices. Indicates which
#' outcomes this rule will apply.
rule_not_one_to_zero <- function(m, term_indices) {
    invisible(.Call(`_defm_rule_not_one_to_zero`, m, term_indices))
}

#' @details The function `rule_constrain_support` will constrain the support of the model
#' by specifying a lower and upper bound for a given statistic.
#' @param lb,ub Numeric scalars. Lower and upper bounds.
#' @param term_index Non-negative scalar. Which term this rule will apply.
#' @rdname defm_terms
#' @export
rule_constrain_support <- function(m, term_index, lb, ub) {
    invisible(.Call(`_defm_rule_constrain_support`, m, term_index, lb, ub))
}

