% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{tib_layer}
\alias{tib_layer}
\alias{simplyconnected_layer}
\alias{inverse_group_lasso_pen}
\alias{regularizer_group_lasso}
\alias{tibgroup_layer}
\alias{layer_hadamard}
\alias{layer_group_hadamard}
\alias{layer_hadamard_diff}
\title{Hadamard-type layers}
\usage{
tib_layer(units, la, ...)

simplyconnected_layer(la, ...)

inverse_group_lasso_pen(la)

regularizer_group_lasso(la, group_idx)

tibgroup_layer(units, group_idx, la, ...)

layer_hadamard(units = 1, la = 0, depth = 3, ...)

layer_group_hadamard(units, la, group_idx, depth, ...)

layer_hadamard_diff(
  units,
  la,
  initu = "glorot_uniform",
  initv = "glorot_uniform",
  ...
)

layer_hadamard(units = 1, la = 0, depth = 3, ...)
}
\arguments{
\item{units}{integer; number of units}

\item{la}{numeric; regularization value (> 0)}

\item{...}{arguments passed to TensorFlow layer}

\item{group_idx}{list of group indices}

\item{depth}{integer; depth of weight factorization}

\item{initu, initv}{initializers for parameters}
}
\value{
layer object
}
\description{
Hadamard-type layers
}
