% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tetra-class.R
\name{deb_tetra}
\alias{deb_tetra}
\title{A class for tetrapartite values}
\usage{
deb_tetra(
  l = double(),
  s = double(),
  d = double(),
  f = double(),
  bases = c(20, 12, 4)
)
}
\arguments{
\item{l}{Numeric vector representing the pounds unit.}

\item{s}{Numeric vector representing the shillings unit.}

\item{d}{Numeric vector representing the pence unit.}

\item{f}{Numeric vector representing the farthing or fourth unit.}

\item{bases}{Numeric vector of length 3 used to specify the bases for the
solidus or s, denarius or d, and farthing or f units. Default is
\code{c(20, 12, 4)}, which conforms to the English system of 1 pound =
20 shillings, 1 shilling = 12 pence, and 1 pence = 4 farthing.}
}
\value{
Returns a vector of class \code{deb_tetra}.
}
\description{
Create a vector of class \code{deb_tetra} to integrate values with four units
into standardized forms of analysis provided by R.
}
\details{
The \code{deb_tetra} class extends the concept of the \code{deb_lsd} class to
incorporate currencies and other types of values that consist of four units.
A variety of currencies and measurements of weights expanded beyond the
conventional tripartite system of pounds, shillings, and pence to include a
fourth unit. \code{deb_tetra} adds a fourth unit, named \code{f} for farthing, to the
\href{https://en.wikipedia.org/wiki/£sd}{l, s, and d units} used by \code{deb_lsd}.
The \code{bases} attribute of \code{deb_tetra} vectors makes it possible to specify
alternative bases for the \emph{solidus}, \emph{denarius}, and farthing units.

The length of \code{l}, \code{s}, \code{d}, and \code{f} must either be all equal, or a vector of
length 1 can be recycled to the length of the other argument(s). See
the \href{https://vctrs.r-lib.org/articles/type-size.html}{vctrs package}
for further details on recycling vectors. In addition, \code{l}, \code{s}, \code{d}, and \code{f}
must either all have no values, resulting in a vector of length 0, or all
possess numeric vectors.
}
\examples{

deb_tetra(5, 3, 8, 2)
deb_tetra(l = c(10, 8, 5),
          s = c(6, 13, 8),
          d = c(8, 4, 10),
          f = c(2, 3, 1))

# Recycle length 1 vector
deb_tetra(l = c(10, 8, 5),
          s = c(6, 13, 8),
          d = c(8, 4, 10),
          f = 2)

# Set the bases of the deb_tetra vector
deb_tetra(5, 3, 8, 2, bases = c(60, 16, 8))
deb_tetra(l = c(10, 28, 5),
          s = c(6, 33, 13),
          d = c(8, 12, 10),
          f = c(5, 3, 6),
          bases = c(60, 16, 8))

# Create a prototype or vector of length 0
deb_tetra()
}
\seealso{
The \code{deb_tetra} class works in concert with the \code{deb_decimal} class,
which can represent tetrapartite values as decimalized values. See
\code{\link[=deb_decimal]{deb_decimal()}}. To represent values with tripartite units see
\code{\link[=deb_lsd]{deb_lsd()}}.
}
