% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/horzLollipop.R
\name{horzLollipop}
\alias{horzLollipop}
\title{Create a horizontal lollipop chart}
\usage{
horzLollipop(
  data,
  label,
  value,
  sort = "none",
  bgcol = "white",
  valueTicks = NULL,
  labelTicks = NULL,
  valueFontSize = 12,
  labelFontSize = 12,
  font = "Verdana, Geneva, Tahoma, sans-serif",
  valueTitle = NULL,
  valueTitleFontSize = 14,
  labelTitle = NULL,
  labelTitleFontSize = 14,
  title = NULL,
  titleFontSize = 20,
  lineStroke = "maroon",
  lineStrokeWidth = 4,
  circleFill = "lime",
  circleStroke = "lime",
  circleStrokeWidth = 1,
  circleRadius = 5,
  axisCol = "black",
  width = NULL,
  height = NULL
)
}
\arguments{
\item{data}{The data frame containing the variables to consider.}

\item{label}{The categorical variable to consider. Will be plotted on the x-axis.}

\item{value}{The numeric variable to consider. Will be plotted on the y-axis.}

\item{sort}{Whether to sort or not the vertical lines. Takes three values
'none' which is the default, 'ascending' or 'descending'.}

\item{bgcol}{The background-color of the SVG output. Defaults to 'salmon'.}

\item{valueTicks}{Optional. the number of x-axis ticks to consider.}

\item{labelTicks}{Optional. The number of y-axis ticks to consider.}

\item{valueFontSize}{the font size of the x-axis labels. Defaults to 10.}

\item{labelFontSize}{the font size of the y-axis labels. Defaults to 10.}

\item{font}{The font family to consider for the titles. Defaults to
"Verdana, Geneva, Tahoma, sans-serif".}

\item{valueTitle}{Optional. The title of the x-axis.}

\item{valueTitleFontSize}{The font size of the x-axis title. Defaults to 14.}

\item{labelTitle}{Optional. The title of the y-axis.}

\item{labelTitleFontSize}{The font size of the y-axis title. Defaults to 14.}

\item{title}{Optional. The title of the plot.}

\item{titleFontSize}{The font size of the plot title. Defaults to 22.}

\item{lineStroke}{The stroke color of the vertical lines. Defaults to 'maroon'.}

\item{lineStrokeWidth}{The vertical lines stroke's width. Defaults to 4.}

\item{circleFill}{The color of the circles. Defaults to 'lime'.}

\item{circleStroke}{The color of the stroke surrounding the circle. Defaults to 'lime'.}

\item{circleStrokeWidth}{The width of the circles' stroke. Defaults to 1.}

\item{circleRadius}{The radius of the circles. Defaults to 10.}

\item{axisCol}{the color of the x and y axis. It includes the ticks, the labels and titles.
Defaults to 'black'.}

\item{width}{Optional. The width of the SVG output.}

\item{height}{Optional. The height of the SVG output.}
}
\value{
A SVG horizontal lollipop chart.
}
\description{
Create a horizontal lollipop chart
}
