% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxplot.R
\name{db_compute_boxplot}
\alias{db_compute_boxplot}
\title{Returns a dataframe with boxplot calculations}
\usage{
db_compute_boxplot(data, x, var, coef = 1.5)
}
\arguments{
\item{data}{A table (tbl), can already contain additional grouping vars specified}

\item{x}{A discrete variable in which to group the boxplots}

\item{var}{A continuous variable}

\item{coef}{Length of the whiskers as multiple of IQR. Defaults to 1.5}
}
\description{
Uses very generic dplyr code to create boxplot calculations.
Because of this approach,
the calculations automatically run inside the database if `data` has
a database or sparklyr connection. The `class()` of such tables
in R are: tbl_sql, tbl_dbi, tbl_spark

It currently only works with Spark, Hive, and SQL Server connections.

Note that this function supports input tbl that already contains
grouping variables. This can be useful when creating faceted boxplots.
}
\examples{

mtcars \%>\%
  db_compute_boxplot(am, mpg)
}
