% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/racusum_limit_dpcl.R
\name{racusum_limit_dpcl}
\alias{racusum_limit_dpcl}
\title{Dynamic Probability Control Limits (DPCL)}
\usage{
racusum_limit_dpcl(patient_risks, N = 1e+05, odds_multiplier = 2,
  alpha, seed = NULL)
}
\arguments{
\item{patient_risks}{Double. Vector of patient risk scores (individual risk of adverse event)}

\item{N}{Integer. Number of simulation runs}

\item{odds_multiplier}{Double. Odds multiplier of adverse event under the alternative hypothesis (<1 looks for decreases)}

\item{alpha}{Double. False signal probability of RA-CUSUM}

\item{seed}{Integer. Seed for RNG}
}
\value{
Returns vector of dynamic control limit for signalling performance change (double)
}
\description{
Set DPCL for risk-adjusted Bernoulli CUSUM Charts
}
\examples{
patient_risks <- runif(100, min = 0.1, max = 0.8)

dpcl <- racusum_limit_dpcl(
  patient_risks = patient_risks,
  N = 1000,
  odds_multiplier = 2,
  alpha = 0.05,
  seed = 32423
)

plot(dpcl, type = "l")
}
\references{
Zhang, Xiang & Woodall, William. (2016). Dynamic Probability Control Limits for Lower and Two-Sided Risk-Adjusted Bernoulli CUSUM Charts. Quality and Reliability Engineering International. 10.1002/qre.2044.
}
