% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cubble-class.R
\name{cubble}
\alias{cubble}
\alias{make_cubble}
\title{Create a cubble object}
\usage{
cubble(..., key, index, coords)

make_cubble(
  spatial,
  temporal,
  by = NULL,
  key,
  index,
  coords,
  potential_match = NULL,
  key_use = "temporal"
)
}
\arguments{
\item{...}{a set of name-value pairs to create a cubble, need to include the
\code{key}, \code{index}, and \code{coords} variables.}

\item{key}{a character (or symbol), the spatial identifier. See the Key
section in \code{\link[tsibble:as-tsibble]{tsibble::as_tsibble()}}}

\item{index}{a character (or symbol), the temporal identifier.
Currently support base R classes \code{Date}, \code{POSIXlt},
\code{POSIXct} and tsibble's \code{\link[tsibble:year-month]{tsibble::yearmonth()}}, \code{\link[tsibble:year-week]{tsibble::yearweek()}},
and \code{\link[tsibble:year-quarter]{tsibble::yearquarter()}} class. See the Index section in
\code{\link[tsibble:as-tsibble]{tsibble::as_tsibble()}}}

\item{coords}{a vector of character (or symbol) of length two, in the order of
longitude first and then latitude, the argument can be omitted if created
from an sf and its subclasses. In case the sf geometry column is not POINT,
coords will be the centroid coordinates.}

\item{spatial}{a tibble object or an sf object, the spatial component
containing the \code{key} and \code{coords} variable (\code{coords} can be automatically
created from an \code{sf} object if not supplied).}

\item{temporal}{a tibble object or a tsibble object, the temporal component
containing the \code{key} and \code{index} variable.}

\item{by}{in the syntax of the \code{by} argument in \code{\link[dplyr:mutate-joins]{dplyr::left_join()}},
used in \code{make_cubble()} when the key variable has different names in the
\code{spatial} and \code{temporal} data.}

\item{potential_match}{a \code{key_tbl} object from \code{\link[=check_key]{check_key()}}.
When unmatched key values appear in spatial and temporal data,
\code{make_cubble} will prompt the user to use \code{\link[=check_key]{check_key()}} for
checking. This argument allow the check result to be parsed back to
\code{make_cubble} to also match the \code{potential_pairs} found by the
check.}

\item{key_use}{a character of either "spatial" or "temporal". When
\code{potential_math} is activated, this argument specifies which key column
in the potential match to use. Default to "temporal".}
}
\value{
a cubble object
}
\description{
Create a cubble object
}
\examples{
cubble(
  id = rep(c("perth", "melbourne", "sydney"), each = 3),
  date = rep(as.Date("2020-01-01") + 0:2, times = 3),
  long = rep(c(115.86, 144.96, 151.21), each = 3),
  lat = rep(c(-31.95, -37.81, -33.87), each = 3),
  value = rnorm(n = 9),
  key = id, index = date, coords = c(long, lat)
  )

# stations and climate are in-built data in cubble
make_cubble(spatial = stations, temporal = meteo,
            key = id, index = date, coords = c(long, lat))

}
