% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scytale.R
\name{scytale}
\alias{scytale}
\title{Scytale cipher}
\usage{
scytale(message, col, encrypt = TRUE)
}
\arguments{
\item{message}{A character vector}

\item{col}{A positive integer, this determines the number of columns in the encryption matrix. 1 column will have no effect}

\item{encrypt}{(Default: \code{TRUE}) TRUE will encrypt the message, while FALSE will decrypt the message.}
}
\value{
A character vector of either plaintext that has been encrypted or ciphertext that has been decrypted.
}
\description{
This can be used to encrypt and decrypt a
Scytale cipher. A Scytale cipher is an ancient form of cryptography that wraps a message (typically written
on a long thing piece of paper) around a device to create a matrix with a fixed number of columns that transposes
the text.
}
\examples{
scytale("very super secret message!", col = 4, encrypt = TRUE)
scytale("v eetseesrc s!ru rmaypseeg", col = 4, encrypt = FALSE)

}
