% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_ts.R
\name{output_summary}
\alias{output_summary}
\title{Summarize the simulation results and generate the regret plot}
\usage{
output_summary(
  S = 30,
  num_cov = 4,
  T.init = 20,
  T0 = 1000,
  alpha = 1,
  gam = 25,
  K = 20,
  dist_env = c("Negative Binomial", "Poisson", "Linear TS", "ZIP", "ZINB"),
  show_figure = TRUE
)
}
\arguments{
\item{S}{number of replicates of the experiment (greater than 1). Default is 30.}

\item{num_cov}{dimension for beta and gamma; we assume that they have the same dimensions for now. Default is 4.}

\item{T.init}{length of the initial exploration stage. Default is 20.}

\item{T0}{number of decision times. Default is 1000.}

\item{alpha}{tuning parameter that controls the exploration-exploitation tradeoff. Default is 1.}

\item{gam}{over dispersion level of the environment model; this is only useful when the environment model is negative binomial or zero-inflated negative binomial. Default is 25.}

\item{K}{number of actions/intervention options. Default is 20.}

\item{dist_env}{tuning parameter that controls which environment model to use, with the options "Negative Binomial", "Poisson", "Linear TS", "ZIP", "ZINB"}

\item{show_figure}{A logical flag specifying that the regret plot of the model should be returned if true (default), otherwise, false.}
}
\value{
The summary of the simulation results with cumulative regret, regret, and parameters is generated along with the optional
output of the regret plot (\code{show_figure} = TRUE).
}
\description{
Summarize the simulation results and generate the regret plot
}
\examples{
output_summary(S = 2, num_cov = 2, T.init = 3, T0 = 5, dist_env = "Negative Binomial")
}
\references{
\itemize{
\item Liu, X., Deliu, N., Chakraborty, T., Bell, L., & Chakraborty, B. (2023).
Thompson sampling for zero-inflated count outcomes with an application to the Drink Less mobile health study.
arXiv preprint arXiv:2311.14359. \url{https://arxiv.org/abs/2311.14359}}
}
