% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_config.R
\name{extract_metadata}
\alias{extract_metadata}
\title{Extract metadata from connectors}
\usage{
extract_metadata(connectors, name = NULL)
}
\arguments{
\item{connectors}{An object containing connectors with a "metadata" attribute.}

\item{name}{A character string specifying which metadata attribute to extract.
If \code{NULL} (default), returns all metadata.}
}
\value{
A list containing the metadata extracted from the "metadata" attribute,
or the specific attribute value if \code{name} is specified.
}
\description{
This function extracts the "metadata" attribute from a connectors object,
with optional filtering to return only a specific metadata field.
}
\examples{
# A config list with metadata
config <- list(
  metadata = list(
    study = "Example Study",
    version = "1.0"
  ),
  datasources = list(
    list(
      name = "adam",
      backend = list(type = "connector_fs", path = tempdir())
    )
  )
)

cnts <- connect(config)

# Extract all metadata
result <- extract_metadata(cnts)
print(result)

# Extract specific metadata field
study_name <- extract_metadata(cnts, name = "study")
print(study_name)

}
