% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_transform.R
\name{compute_transform}
\alias{compute_transform}
\title{Compute transformation matrix A}
\usage{
compute_transform(x, pre_trained, weighting = 500)
}
\arguments{
\item{x}{a (quanteda) \code{fcm-class} object.}

\item{pre_trained}{(numeric) a F x D matrix corresponding to pretrained embeddings,
usually trained on the same corpus as that used for \code{x}.
F = number of features and D = embedding dimensions.
rownames(pre_trained) = set of features for which there is a pre-trained embedding}

\item{weighting}{(character or numeric) weighting options:
\describe{
\item{\code{1}}{no weighting.}
\item{\code{"log"}}{weight by the log of the frequency count.}
\item{\code{numeric}}{threshold based weighting (= 1 if token count meets threshold, 0 ow).}
}
Recommended: use \code{log} for small corpora, a numeric threshold for larger corpora.}
}
\value{
a \code{dgTMatrix-class} D x D non-symmetrical matrix
(D = dimensions of pre-trained embedding space) corresponding
to an 'a la carte' transformation matrix. This matrix is optimized
for the corpus and pre-trained embeddings employed.
}
\description{
Computes a transformation matrix, given a feature-co-occurrence
matrix and corresponding pre-trained embeddings.
}
\examples{

\dontrun{
# example exceeds CRAN CPU time to elapsed time limit
library(quanteda)
# note, cr_sample_corpus is too small to produce sensical word vectors

# tokenize
toks <- tokens(cr_sample_corpus)

# construct feature-co-occurrence matrix
toks_fcm <- fcm(toks, context = "window", window = 6,
count = "weighted", weights = 1 / (1:6), tri = FALSE)

# you will generally want to estimate a new (corpus-specific)
# GloVe model, we will use cr_glove_subset instead
# see the Quick Start Guide to see a full example.

# estimate transform
local_transform <- compute_transform(x = toks_fcm,
pre_trained = cr_glove_subset, weighting = 'log')
}
}
\keyword{compute_transform}
