% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_numbers.R
\name{format_chr}
\alias{format_chr}
\title{Format character strings with italics and type}
\usage{
format_chr(x, italics = TRUE, type = "md")
}
\arguments{
\item{x}{Character string.}

\item{italics}{Logical value (default = TRUE) for whether text should be
italicized.}

\item{type}{Type of formatting (\code{"md"} = markdown, \code{"latex"} = LaTeX).}
}
\value{
A character string that has either Markdown or LaTeX formatting for italics
or not.
}
\description{
Format character strings with italics and type
}
\examples{
format_chr("Hello world!")
# Format in LaTeX syntax
format_chr("Hello world!", type = "latex")
# Remove italics
format_chr("Hello world!", italics = FALSE)
}
