% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{str_match_replace}
\alias{str_match_replace}
\title{Match string and replace with corresponding value}
\usage{
str_match_replace(x, to_match, to_replace)
}
\arguments{
\item{x}{A vector.}

\item{to_match}{A vector of strings to be matched.}

\item{to_replace}{A vector of strings to replace the matched ones, must have the same length as \code{to_match}.}
}
\value{
A vector.
}
\description{
Partially match a string and replace with corresponding value. This function is useful to recover
the original names of variables after legalized using \code{make.names} or modified by other functions.
}
\examples{
ori_names <- c("xx (mg/dl)", "b*x", "Covid-19")
modified_names <- c("v1", "v2", "v3")
x <- c("v1.v2", "v3.yy", "v4")
str_match_replace(x, modified_names, ori_names)
}
