% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotting.R
\name{climplot}
\alias{climplot}
\title{Create Maps using the `terra` package graphic parameters}
\usage{
climplot(
  envrmt = .GlobalEnv$envrmt,
  mnote,
  sensor,
  aoa = FALSE,
  mapcolors = rev(grDevices::terrain.colors(50)),
  scale_position = "bottomleft",
  north_position = "topright"
)
}
\arguments{
\item{envrmt}{variable name of your envrmt list created using climodr's `envi.create` function. Default = envrmt.}

\item{mnote}{character. The modelnote you want to create maps of.}

\item{sensor}{character. The sensor you want to create maps for.}

\item{aoa}{logical. Do you want the area of applicability to be added to your map?}

\item{mapcolors}{The color pallete you want to use for the map. Default is `rev(grDevices::terrain.colors(50))`}

\item{scale_position}{character. Graphical parameter. The relative positiion of the Scale for the map. See `terra::plot` for more details.}

\item{north_position}{character. Graphical parameter. The relative positiion of the Scale for the map. See `terra::plot` for more details.}
}
\value{
Maps in PNG-Format to your harddrive.
}
\description{
Plot results of climodr into maps. Right now maps are created using the terra package.
The maps created are very basic. Will be updated to run with tidyterra in future.
}
\examples{
\donttest{
#create climodr environment and allow terra-functions to use 70\% of RAM
envrmt <- envi.create(proj_path = tempdir(),
                      memfrac = 0.7)

# Load the climodr example data into the current climodr environment
clim.sample(envrmt = envrmt)

#prepare csv-files
prep.csv(envrmt = envrmt,
         method = "proc",
         save_output = TRUE)

#process csv-files
csv_data <- proc.csv(envrmt = envrmt,
                     method = "monthly",
                     rbind = TRUE,
                     save_output = TRUE)

# Crop all raster bands
crop.all(envrmt = envrmt,
         method = "MB_Timeseries",
         overwrite = TRUE)

# Calculate Indices from cropped raster bands
calc.indices(envrmt = envrmt,
             vi = "all",
             bands = c("blue", "green", "red",
                       "nir", "nirb",
                       "re1", "re2", "re3",
                       "swir1", "swir2"),
             overwrite = TRUE)

#extract station coordinates
csv_spat <- spat.csv(envrmt = envrmt,
                     method = "monthly",
                     des_file = "plot_description.csv",
                     save_output = TRUE)


#extract predictor values from raster files
csv_fin <- fin.csv(envrmt = envrmt,
                   method = "monthly",
                   save_output = TRUE)

# Test data for autocorrelation after running fin.csv
autocorr(envrmt = envrmt,
         method = "monthly",
         resp = 5,
         pred = c(8:23),
         plot.corrplot = FALSE)

# Create 36 different models (12 months x 3 classifiers) for every month in 2017
calc.model(envrmt = envrmt,
           method = "monthly",
           timespan = c(2017),
           climresp = 5,
           classifier = c("rf",
                          "pls",
                          "lm"),
           seed = 707,
           p = 0.8,
           folds = "LLO",
           mnote = "normal",
           predrows = c(8:23),
           tc_method = "cv",
           metric = "RMSE",
           autocorrelation = TRUE,
           doParallel = FALSE)

# Make predictions
climpred(envrmt = envrmt,
         method = "monthly",
         mnote = "normal",
         AOA = TRUE)

# Create a Temperature Map from the vignette model
climplot(envrmt = envrmt,
         mnote = "normal",
         sensor = "Ta_200",
         aoa = TRUE,
         mapcolors = rev(heat.colors(50)),
         scale_position = "bottomleft",
         north_position = "topright")
}
}
\seealso{
`terra::plot`
}
