% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clc.R
\name{copy_to}
\alias{copy_to}
\alias{copy_to.clc}
\title{Copy a Style to a GeoPackage or PostGIS Database}
\usage{
copy_to(clo, to, database, schema, layers)

\method{copy_to}{clc}(clo, to, database = NULL, schema = "public", layers = NULL)
}
\arguments{
\item{clo}{A `clc` object.}

\item{to}{A data destination for the output. This can be:
- A string representing the path to a GeoPackage file.
- A `DBI` database connection object to a PostGIS database, created using [RPostgres::dbConnect()].}

\item{database}{A string, database name, only in case the destination is in PostGIS.}

\item{schema}{A string, schema name, only in case the destination is in PostGIS.
Defaults to `'public'`.}

\item{layers}{An optional character vector specifying the names of layers in the
destination to which the styles should be applied. If `NULL` (default), applies
the style to all layers.}
}
\value{
clo A `clc` object.
}
\description{
This function copies a style to the specified layers in a GeoPackage file or
a PostGIS database. The destination is determined by the `to` argument.
}
\examples{
source_gpkg <- system.file("extdata", "clc.gpkg", package = "clc")
clo <- clc(source = source_gpkg, layer_name = "clc")

out_gpkg <- tempfile(fileext = ".gpkg")
clo <- clo |>
  save_to(out_gpkg)

# ex1
clo <- clo |>
  copy_to(out_gpkg, layers = 'clc')

\dontrun{
conn <- RPostgres::dbConnect(
  RPostgres::Postgres(),
  dbname = 'exampledb',
  host = 'localhost',
  port = '5432',
  user = 'user',
  password = 'password'
)
clo <- clo |>
  save_to(conn, 'exampledb')

# ex2
clo <- clo |>
  copy_to(conn, 'exampledb', layers = 'clc')
}
}
\seealso{
Other CLC class functions: 
\code{\link{as_raster}()},
\code{\link{clc}()},
\code{\link{cut_to_extent}()},
\code{\link{get_colors.clc}()},
\code{\link{get_levels.clc}()},
\code{\link{get_raster}()},
\code{\link{plot_clc}()},
\code{\link{prepare_plot}()},
\code{\link{save_to}()}
}
\concept{CLC class functions}
