% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_analysis.R
\name{ssm_analyze}
\alias{ssm_analyze}
\title{Perform analyses using the Structural Summary Method}
\usage{
ssm_analyze(
  data,
  scales,
  angles = octants(),
  measures = NULL,
  grouping = NULL,
  contrast = FALSE,
  boots = 2000,
  interval = 0.95,
  listwise = TRUE,
  measures_labels = NULL
)
}
\arguments{
\item{data}{Required. A data frame containing at least circumplex scales.}

\item{scales}{Required. A character vector of column names, or a numeric
vector of column indexes, from \code{data} that contains the circumplex scale
scores to be analyzed.}

\item{angles}{Optional. A numeric vector containing the angular displacement
of each circumplex scale included in \code{scales} (in degrees). (default =
\code{octants()}).}

\item{measures}{Optional. Either \code{NULL} or a character vector of column names
from \code{data} that contains one or more variables to be correlated with the
circumplex scales and analyzed using correlation-based SSM analyses.}

\item{grouping}{Optional. Either \code{NULL} or a string that contains the column
name from \code{data} of the variable that indicates the group membership of
each observation.}

\item{contrast}{Optional. A logical indicating whether to output the
difference between two measures' or two groups' SSM parameters. Can only be
set to TRUE when there are exactly two measures and one group, one measure
and two groups, or no measures and two groups (default = FALSE).}

\item{boots}{Optional. A single positive whole number indicating how many
bootstrap resamples to use when estimating the confidence intervals
(default = 2000).}

\item{interval}{Optional. A single positive number between 0 and 1
(exclusive) that indicates what confidence level to use when estimating the
confidence intervals (default = 0.95).}

\item{listwise}{Optional. A logical indicating whether missing values should
be handled by listwise deletion (TRUE) or pairwise deletion (FALSE). Note
that pairwise deletion may result in different missing data patterns in
each bootstrap resample and is slower to compute (default = TRUE).}

\item{measures_labels}{Optional. Either \code{NULL} or a character vector
providing a label for each measure provided in \code{measures} (in the same
order) to appear in the results as well as tables and plots derived from
the results.}
}
\value{
A list containing the results and description of the analysis.
\item{results}{A data frame with the SSM parameter estimates}
\item{details}{A list with the number of bootstrap resamples (boots),
the confidence interval percentage level (interval), and the angular
displacement of scales (angles)}
\item{call}{A language object containing the function call that created
this object}
\item{scores}{A data frame containing the mean scale scores} \item{type}{A
string indicating what type of SSM analysis was done}
}
\description{
Calculate SSM parameters with bootstrapped confidence intervals for a variety
of different analysis types. Depending on what arguments are supplied, either
mean-based or correlation-based analyses will be performed, one or more
groups will be used to stratify the data, and contrasts between groups or
measures will be calculated.
}
\examples{
# Load example data
data("jz2017")

# Single-group mean-based SSM
ssm_analyze(
  jz2017,
  scales = c("PA", "BC", "DE", "FG", "HI", "JK", "LM", "NO")
)

# Single-group correlation-based SSM
ssm_analyze(
  jz2017,
  scales = c("PA", "BC", "DE", "FG", "HI", "JK", "LM", "NO"),
  measures = c("NARPD", "ASPD")
)
\donttest{
# Multiple-group mean-based SSM
ssm_analyze(
  jz2017,
  scales = c("PA", "BC", "DE", "FG", "HI", "JK", "LM", "NO"),
  grouping = "Gender"
)

# Multiple-group mean-based SSM with contrast
ssm_analyze(
  jz2017,
  scales = c("PA", "BC", "DE", "FG", "HI", "JK", "LM", "NO"),
  grouping = "Gender",
  contrast = TRUE
)

# Single-group correlation-based SSM with contrast
ssm_analyze(
  jz2017,
  scales = c("PA", "BC", "DE", "FG", "HI", "JK", "LM", "NO"),
  measures = c("NARPD", "ASPD"),
  contrast = TRUE
)

# Multiple-group correlation-based SSM
ssm_analyze(
  jz2017,
  scales = c("PA", "BC", "DE", "FG", "HI", "JK", "LM", "NO"),
  measures = "NARPD",
  grouping = "Gender"
)

# Multiple-group correlation-based SSM with contrast
ssm_analyze(
  jz2017,
  scales = c("PA", "BC", "DE", "FG", "HI", "JK", "LM", "NO"),
  measures = "NARPD",
  grouping = "Gender",
  contrast = TRUE
)
}

}
\seealso{
Other ssm functions: 
\code{\link{ssm_parameters}()},
\code{\link{ssm_score}()},
\code{\link{ssm_table}()}

Other analysis functions: 
\code{\link{ssm_parameters}()},
\code{\link{ssm_score}()}
}
\concept{analysis functions}
\concept{ssm functions}
