% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ts_set}
\alias{ts_set}
\title{Tech Stock Time Series Dataset}
\format{
A data frame with 2095 observations of 5 variables:
\describe{
  \item{dates}{Character vector of dates in "YYYY-MM-DD" format.}
  \item{TSLA.Close}{Numeric. Closing prices for Tesla (TSLA).}
  \item{AMZN.Close}{Numeric. Closing prices for Amazon (AMZN).}
  \item{IBM.Close}{Numeric. Closing prices for IBM.}
  \item{META.Close}{Numeric. Closing prices for Meta (Facebook).}
}
}
\usage{
data(ts_set)
}
\description{
A multivariate dataset for closing prices for several major tech stocks over time. Source: YahooFinance.
}
\examples{
data(ts_set)
plot(as.Date(ts_set$dates), ts_set$TSLA.Close, type = "l")
}
\keyword{datasets}
