#'Tech Stock Time Series Dataset
#'
#' A multivariate dataset for closing prices for several major tech stocks over time. Source: YahooFinance.
#'
#' @format A data frame with 2095 observations of 5 variables:
#' \describe{
#'   \item{dates}{Character vector of dates in "YYYY-MM-DD" format.}
#'   \item{TSLA.Close}{Numeric. Closing prices for Tesla (TSLA).}
#'   \item{AMZN.Close}{Numeric. Closing prices for Amazon (AMZN).}
#'   \item{IBM.Close}{Numeric. Closing prices for IBM.}
#'   \item{META.Close}{Numeric. Closing prices for Meta (Facebook).}
#' }
#'
#' @usage data(ts_set)
#'
#' @examples
#' data(ts_set)
#' plot(as.Date(ts_set$dates), ts_set$TSLA.Close, type = "l")
"ts_set"
