% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caseLocator.R
\name{caseLocator}
\alias{caseLocator}
\title{Locate case by numerical ID.}
\usage{
caseLocator(case = 1, zoom = FALSE, observed = TRUE, latlong = FALSE,
  add.title = TRUE, highlight.segment = TRUE, data = FALSE,
  add = FALSE, col = "red", vestry = FALSE)
}
\arguments{
\item{case}{Numeric or Integer. Whole number between 1 and 578.}

\item{zoom}{Logical or Numeric. Positive numbers zoom in; negative numbers zoom out.}

\item{observed}{Logical. \code{TRUE} for observed. \code{FALSE} for simulated.}

\item{latlong}{Logical. Longitude and latitude coordinates}

\item{add.title}{Logical. Include title.}

\item{highlight.segment}{Logical. Highlight case's segment.}

\item{data}{Logical. Output data.}

\item{add}{Logical. Add to existing plot or separate plot.}

\item{col}{Character. Point color.}

\item{vestry}{Logical. \code{TRUE} uses the 14 pumps from the Vestry report. \code{FALSE} uses the 13 in the original map.}
}
\value{
A base R graphics plot.
}
\description{
Highlight selected observed or simulated case and its home road segment.
}
\examples{
caseLocator(290)
caseLocator(290, zoom = TRUE)
caseLocator(290, observed = FALSE)
caseLocator(290, latlong = TRUE, zoom = TRUE)
}
