% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/childfree.R
\docType{package}
\name{childfree}
\alias{childfree-package}
\alias{childfree}
\title{childfree: Access and harmonize childfree demographic data}
\description{
Reads demographic data from a variety of public data sources,
extracting and harmonizing variables useful for the study of childfree individuals.
The identification of childfree individuals and those with other family statuses
uses the framework described by Neal & Neal (2024).

Data can be generated from:
\itemize{
\item Demographic and Health Surveys data using \code{\link[=dhs]{dhs()}}
\item Michigan State University State of the State data using \code{\link[=soss]{soss()}}
\item US CDC National Survey of Family Growth data using \code{\link[=nsfg]{nsfg()}}
}

An introduction to the package is available using \code{vignette("childfree")}, and the detailed
codebooks generated by these functions are available using \code{vignette("codebooks")}.
}
\references{
{Neal, Z. P. and Neal, J. W. (2024). A framework for studying adults who neither have nor want children. \emph{The Family Journal, 32}, 121-130. Version of record: \doi{10.1177/10664807231198869} Preprint: \doi{10.31234/osf.io/fa89m}}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://www.zacharyneal.com/childfree-home}
  \item \url{https://github.com/zpneal/childfree}
  \item Report bugs at \url{https://github.com/zpneal/childfree/issues}
}

}
\author{
\strong{Maintainer}: Zachary Neal \email{zpneal@msu.edu} (\href{https://orcid.org/0000-0003-3076-4995}{ORCID})

Authors:
\itemize{
  \item Jennifer Watling Neal \email{jneal@msu.edu} (\href{https://orcid.org/0000-0002-7749-8121}{ORCID})
}

}
