% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchFunction.R
\name{searchFunction}
\alias{searchFunction}
\title{Search R Functions based on Text}
\usage{
searchFunction(
  Summary_nch = 100,
  Model = "gpt-4o-mini",
  SelectedCode = TRUE,
  verbose = TRUE,
  SlowTone = FALSE
)
}
\arguments{
\item{Summary_nch}{Numeric, number of characters to limit the function description (default = 100).}

\item{Model}{String, the model used for the search, default is "gpt-4o-mini".}

\item{SelectedCode}{Logical, whether to get text from RStudio selection (default = TRUE).}

\item{verbose}{Logical, whether to print the results verbosely (default = TRUE).}

\item{SlowTone}{Logical, whether to slow down the print speed for readability (default = FALSE).}
}
\value{
Console output of the identified R function, its package, and a brief description.
}
\description{
Searches for an R function related to the provided text
  either through the RStudio editor selection or clipboard.
}
\details{
Search the R function based on the provided text

This function searches for an R function that corresponds to the text
provided either through the RStudio editor selection or the clipboard.
It fetches the related R function and outputs its name, package, and
a brief description. The function uses GPT-4 for its underlying search.
}
\examples{
\dontrun{
# To search for an R function related to "linear regression"
searchFunction(Summary_nch = 50, SelectedCode = FALSE)
}

}
\author{
Satoshi Kume
}
