% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dag_diagrammer.R
\name{dag_diagrammer}
\alias{dag_diagrammer}
\title{Convert graph to Diagrammer object for visualization}
\usage{
dag_diagrammer(
  graph,
  wrapWidth = 24,
  shortLabel = FALSE,
  fillColor = "aliceblue",
  fillColorObs = "cadetblue"
)
}
\arguments{
\item{graph}{a graph object of class \code{causact_graph} created using \code{dag_create()}.}

\item{wrapWidth}{a required character label that describes the node.}

\item{shortLabel}{a longer more descriptive character label for the node.}

\item{fillColor}{a valid R color to be used as the default node fill color.}

\item{fillColorObs}{a valid R color to be used as the fill color for observed nodes.}
}
\value{
a graph object of class \code{dgr_graph}.  Useful for further customizing graph displays using the \code{DiagrammeR} package.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Convert a \code{causact_graph} to a \code{DiagrammeR} object for visualization.
}
\examples{
library("DiagrammeR")
dag_create() \%>\%
dag_node("Get Card","y",
         rhs = bernoulli(theta),
         data = carModelDF$getCard) \%>\%
  dag_diagrammer() \%>\%
  render_graph(title = "DiagrammeR Version of causact_graph")
}
