% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catsim.R
\name{catmssim_3d_cube}
\alias{catmssim_3d_cube}
\title{Multiscale Categorical Structural Similarity Index Measure for a Cube (3D)}
\usage{
catmssim_3d_cube(
  x,
  y,
  levels = NULL,
  weights = NULL,
  window = 5,
  method = "Cohen",
  ...,
  random = "random"
)
}
\arguments{
\item{x, y}{a binary or categorical image}

\item{levels}{how many levels of downsampling to use. By default, 5. If
\code{weights} is specified and this is left blank, the argument
will be inferred from the number of weights specified.}

\item{weights}{a vector of weights for the different scales. By default,
equal to \code{rep(1,levels)/levels}. If specified, there must
at least as many  weights as there are levels and the first
\code{levels} weights will be used.}

\item{window}{by default 11 for 2D and 5 for 3D images,
but can be specified as a
vector if the window sizes differ by dimension.
The vector must have the same number of
dimensions as the inputted \code{x} and \code{y}.}

\item{method}{whether to use Cohen's kappa (\code{Cohen}),
Jaccard Index (\code{Jaccard}), Dice index (\code{Dice}),
accuracy (\code{accuracy}),  Rand index (\code{Rand}),
Adjusted Rand Index (\code{AdjRand} or \code{ARI}), normalized mutual
information (\code{NMI} or \code{MI}) or the adjusted mutual
information, \code{AMI} and \code{ami}, as
the similarity index. Note Jaccard and Dice should only be used on
binary data.}

\item{...}{additional constants can be passed to internal functions.}

\item{random}{whether to have deterministic PRNG (\code{pseudo})
or to use \code{\link[=sample]{sample()}} (\code{random}). If \code{NULL},
will choose the first mode. For complete reproducibility,
use \code{pseudo} or \code{NULL}.}
}
\value{
a value less than 1 indicating the similarity between the images.
}
\description{
The categorical structural similarity index measure for 3D
categorical or binary images for multiple scales.
The default is to compute over 5 scales.
This computes a 3D measure based on \eqn{5 \times 5 \times 5}{5x5x5}
windows by default with 5 levels of downsampling.
}
\examples{
set.seed(20181207)
dim <- 16
x <- array(sample(0:4, dim^3, replace = TRUE), dim = c(dim, dim, dim))
y <- x
for (j in 1:dim) {
  for (i in 1:dim) y[i, i, j] <- 0
  for (i in 1:(dim - 1)) y[i, i + 1, j] <- 0
}
catmssim_3d_cube(x, y, weights = c(.75, .25))
# Now using a different similarity score
catmssim_3d_cube(x, y, weights = c(.75, .25), method = "Accuracy")
}
