% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ol_comp_summary.R
\name{ol_comp_summary}
\alias{ol_comp_summary}
\title{Summarize Overload Compensation}
\usage{
ol_comp_summary(
  schedule_df,
  instructor = NULL,
  L = 4,
  U = 9,
  rate_per_cr = 2500/3,
  reg_load = 12,
  favor_institution = TRUE
)
}
\arguments{
\item{schedule_df}{A data frame containing course schedule information. Must include
columns such as \code{INSTRUCTOR}, \code{HRS}, and \code{ENRLD}.}

\item{instructor}{Optional string. If provided, limits the summary to a single instructor.
Default is NULL (includes all instructors).}

\item{L}{Minimum enrollment required for overload pay eligibility. Default is 4.}

\item{U}{Upper threshold for proration. Courses with ENRLD > U receive full-rate pay.
Default is 9.}

\item{rate_per_cr}{Overload pay rate per credit hour. Default is 2500/3.}

\item{reg_load}{Regular teaching load in credit hours. Default is 12.}

\item{favor_institution}{Logical: if TRUE (default), prioritizes high-enrollment courses for regular load.}
}
\value{
A tibble combining course-level compensation and a summary section for each instructor.
}
\description{
Calculates overload compensation for each instructor based on institutional policy.
The output includes course-level payments, qualified credit hours, and a readable
instructor-level summary block that follows each instructor's courses.
}
\details{
If the \code{instructor} argument is specified, the function limits the summary to that instructor.
Matching is exact and case-sensitive unless pre-filtered using \code{get_instructor_schedule()},
which supports regex-based, case-insensitive pattern matching (e.g., \code{"smith|jones"}).
}
