% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maps.R
\docType{data}
\name{bruneimap}
\alias{bruneimap}
\alias{dis_sf}
\alias{mkm_sf}
\alias{kpg_sf}
\alias{brn_sf}
\title{Simple feature objects to plot Brunei maps}
\format{
An object of class \code{sf} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 4 rows and 7 columns.

An object of class \code{sf} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 39 rows and 8 columns.

An object of class \code{sf} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 438 rows and 9 columns.

An object of class \code{sf} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 17 rows and 2 columns.
}
\usage{
dis_sf

mkm_sf

kpg_sf

brn_sf
}
\description{
Simple feature objects to plot Brunei maps
}
\details{
There are three simple feature objects in this package that can be used to
plot Brunei maps:
\itemize{
\item \code{dis_sf}: District-level boundaries
\item \code{mkm_sf}: Mukim-level boundaries
\item \code{kpg_sf}: Kampong-level boundaries
\item \code{brn_sf}: A sillhouette of Brunei
}
}
\examples{
library(ggplot2)

# District-level boundaries
ggplot(dis_sf) +
  geom_sf()

# Mukim-level boundaries
ggplot(mkm_sf) +
  geom_sf()

# Kampong-level boundaries
ggplot(kpg_sf) +
  geom_sf()
}
\keyword{datasets}
