% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pFinalSizeSwitch1.R
\name{pFinalSizeSwitch1}
\alias{pFinalSizeSwitch1}
\title{Probability of final outbreak size with offspring distribution parameters switched after generation one}
\usage{
pFinalSizeSwitch1(n, j, R0, k0, Rc, kc)
}
\arguments{
\item{n}{Number of initial cases in generation 0}

\item{j}{Total outbreak size (>= n).}

\item{R0}{Mean of negative binomial offspring distribution from generation one}

\item{k0}{Dispersion of negative binomial offspring distribution from generation one}

\item{Rc}{Mean of negative binomial offspring distribution from generation two on}

\item{kc}{Dispersion of negative binomial offspring distribution from generation two on}
}
\value{
The probability of the final outbreak size
}
\description{
pFinalSizeSwitch1 is the probability that n initial cases lead to an extinguished
outbreak of total size j after any number of transmission generations (j includes
the n initial cases)
}
\examples{
#With 5 initial cases, the probability that the final outbreak size is 5 to 20
#(including the initial 5):
pFinalSizeSwitch1(n=5, j=5:20, R0=2, k0=0.1, Rc=0.2, kc=0.1)
}
