% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BootstrapWeightsMethods.R
\name{boot.weights.stsrs}
\alias{boot.weights.stsrs}
\title{Bootstrap Weights Methods for Survey Data}
\usage{
boot.weights.stsrs(
  data,
  population.size,
  R,
  parameter = "total",
  bootstrap.method = "Rao.Wu.Yue",
  boot.sample.size = NULL,
  distribution.adjust = NULL,
  epsilon = NULL
)
}
\arguments{
\item{data}{A vector, matrix or data frame. If it is a matrix or data frame then the column of study variable has to be named \code{study.variable}.  If the sampling design is STSRSWOR, a column identifying strata named \code{stratum} has to be included.}

\item{population.size}{A vector of stratum population sizes}

\item{R}{The number of bootstrap replicates}

\item{parameter}{One of the following population parameters can be applied: \code{"total"} (population total), \code{"mean"} (population mean), \code{"quartile.25"} (population 1st quartile), \code{"quartile.50"} or \code{"median"} (population median) or \code{"quartile.75"} (population 3rd quartile). If the parameter of interest is the population mean or total, the HT-estimator is applied. If the parameter of interest is a population quartile, the estimator in Sarndal, Swensson, and Wretman (1992, Chapter 5) is applied. The default is the population total.}

\item{bootstrap.method}{One of the following bootstrap methods can be applied: \code{"Rao.Wu.Yue"} (Rao, Wu and Yue, 1992),\code{"Bertail.Combris"} (Bertail and Combris, 1997), \code{"Chipperfield.Preston"} (Chipperfield and Preston, 2007) or \code{"Beaumont.Patak"} (Beaumont and Patak, 2012). The default is \code{"Rao.Wu.Yue"}.}

\item{boot.sample.size}{A vector of bootstrap sample sizes within strata only required for the method of Rao, Wu and Yue (1992). The length of this vector has to be the same as the number of strata. The default is NULL. If the method of Rao, Wu and Yue (1992) is applied and \code{boot.sample.size} is not specified, the bootstrap sample size will be \code{nh-1} within each stratum, where \code{nh} is the original sample size within stratum \code{h}.}

\item{distribution.adjust}{The default is NULL. A distribution should be specified for the method of Bertail and Combris (1997) and Beaumont and Patak (2012) to generate the bootstrap weight adjustments if epsilon is NULL. One of the following distribution can be used: \code{"Normal"}, \code{"Lognormal"}, \code{"Exponential"} or \code{"Uniform"}.}

\item{epsilon}{The default is NULL. If either Bertail and Combris (1997) or Beaumont and Patak (2012) is applied and \code{distribution.adjust} is NULL, a value must be given to epsilon so that Eq(5) in Beaumont and Patak (2012) can be used to generate the bootstrap weight adjustments.}
}
\value{
\code{boot.statistic} A vector of bootstrap statistics

\code{boot.var} The bootstrap variance estimator of the estimator of parameter of interest.

\code{boot.mean} The average of the bootstrap estimator of the parameter of interest.

\code{boot.sample} A list of results for each iteration. That includes a column of original sample values, a column of bootstrap weight adjustments, a column of bootstrap weights and a column of stratum identifier.
}
\description{
The function \code{boot.weights.stsrs} applies one of the following bootstrap weights methods on complete (full response) survey data selected under either SRSWOR or STSRSWOR: Rao, Wu and Yue (1992), Bertail and Combris (1997), Chipperfield and Preston (2007) and Beaumont and Patak (2012)
}
\examples{

R<- 20

data(data_samp_srs)
population_size<- 6000
# The sampling fraction is about 30\%.
# data_samp_srs is a sample taken from data_pop available in the package.

boot.RWY<- boot.weights.stsrs(data_samp_srs, population_size, R)
boot.RWY$boot.var

boot.CP<- boot.weights.stsrs(data_samp_srs, population_size, R,
           bootstrap.method="Chipperfield.Preston")
boot.CP$boot.var

boot.BP.med<- boot.weights.stsrs(data_samp_srs, population_size, R,
               parameter="median", bootstrap.method="Beaumont.Patak",
               distribution.adjust="Exponential")
boot.BP.med$boot.var
boot.BP.med$boot.sample[[5]]


data(data_samp_stsrs)
population_size_st<- c(4500, 6300, 3500, 2000, 1500)
# The overall sampling fraction is about 30\%.
# data_samp_stsrs is a sample taken from data_pop_st available in the package.

boot.RWY.st<- boot.weights.stsrs(data_samp_stsrs, population_size_st, R)
boot.RWY.st$boot.var
boot.RWY.st$boot.statistic



}
\references{
Beaumont, J.-F. and Patak, Z. (2012). On the generalized bootstrap for sample surveys with special attention to Poisson sampling. International Statistical Review 80 (1), 127–148.

Bertail, P. and Combris, P. (1997). Bootstrap généralisé d’un sondage. Annales d’économie et de statistique 46, 49–83.

Chipperfield, J. and Preston, J. (2007). Efficient bootstrap for business surveys. Survey Methodology 33 (2), 167–172.

Rao, J. N. K., Wu, C. F. J. and Yue, K. (1992). Some recent work on resampling methods for complex surveys. Survey Methodology 18 (2), 209–217.

Särndal, C.-E., Swensson, B. and Wretman, J. (1992). Model-Assisted Survey Sampling. NewYork: Springer.
}
