% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootPLS-package.R
\docType{package}
\name{bootPLS-package}
\alias{bootPLS-package}
\alias{bootPLS}
\title{bootPLS: Bootstrap Hyperparameter Selection for PLS Models and Extensions}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Several implementations of non-parametric stable bootstrap-based techniques to determine the numbers of components for Partial Least Squares linear or generalized linear regression models as well as and sparse Partial Least Squares linear or generalized linear regression models. The package collects techniques that were published in a book chapter (Magnanensi et al. 2016, 'The Multiple Facets of Partial Least Squares and Related Methods', \doi{10.1007/978-3-319-40643-5_18}) and two articles (Magnanensi et al. 2017, 'Statistics and Computing', \doi{10.1007/s11222-016-9651-4}) and (Magnanensi et al. 2021, 'Frontiers in Applied Mathematics and Statistics', \doi{10.3389/fams.2021.693126}).
}
\references{
A new bootstrap-based stopping criterion in PLS component construction,
J. Magnanensi, M. Maumy-Bertrand, N. Meyer and F. Bertrand (2016), in The Multiple Facets of Partial Least Squares and Related Methods, 
\doi{10.1007/978-3-319-40643-5_18}\cr

A new universal resample-stable bootstrap-based stopping criterion for PLS component construction,
J. Magnanensi, F. Bertrand, M. Maumy-Bertrand and N. Meyer, (2017), Statistics and Computing, 27, 757–774. 
\doi{10.1007/s11222-016-9651-4}\cr

New developments in Sparse PLS regression, J. Magnanensi, M. Maumy-Bertrand, 
N. Meyer and F. Bertrand, (2021), Frontiers in Applied Mathematics and Statistics, 
\doi{10.3389/fams.2021.693126}\cr
}
\seealso{
Useful links:
\itemize{
  \item \url{https://fbertran.github.io/bootPLS/}
  \item \url{https://github.com/fbertran/bootPLS/}
  \item Report bugs at \url{https://github.com/fbertran/bootPLS/issues/}
}

}
\author{
\strong{Maintainer}: Frederic Bertrand \email{frederic.bertrand@lecnam.net} (\href{https://orcid.org/0000-0002-0837-8281}{ORCID})

Authors:
\itemize{
  \item Jeremy Magnanensi \email{jeremy.magnanensi@gmail.com}
  \item Myriam Maumy-Bertrand \email{myriam.maumy@ehesp.fr} (\href{https://orcid.org/0000-0002-4615-1512}{ORCID})
}

}
\keyword{internal}
