% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censboot_summary.R
\name{censboot_summary}
\alias{censboot_summary}
\title{Summarising Survival Regression Models Using the Bootstrap}
\usage{
censboot_summary(
  model,
  type = "perc",
  sim = "ordinary",
  strata = NULL,
  coef = "exp",
  conf.level = 0.95,
  R = 999,
  pval_precision = NULL,
  adjust.method = "none",
  ...
)
}
\arguments{
\item{model}{An object fitted using "survival::coxph", "survival::survreg", or "rms::psm".}

\item{type}{A vector of character strings representing the type of interval to base the test on. The value should be one of "norm", "basic", and "perc" (the default).}

\item{sim}{The method used for bootstrapping. See \code{?boot::censboot} for details. Currently only "ordinary" (case resampling) is supported.}

\item{strata}{The strata used in the calls to \code{survfit.} It can be a vector or a matrix with 2 columns. If it is a vector then it is assumed to be the strata for the survival distribution, and the censoring distribution is assumed to be the same for all observations. If it is a matrix then the first column is the strata for the survival distribution and the second is the strata for the censoring distribution. When \code{sim = "ordinary"}, only one set of strata is used to stratify the observations. This is taken to be the first column of \code{strata} when it is a matrix.}

\item{coef}{A string specifying whether to use exponentiated coefficients in the summary table. Either "exp" (for exponentiated coefficients, i.e. hazard ratios in the case of a Cox PH model) or "raw" (for coefficients on their original scale). The default is "exp".}

\item{conf.level}{The confidence level for the confidence intervals. The default is 0.95.}

\item{R}{The number of bootstrap replicates. The default is 999.}

\item{pval_precision}{The desired precision for the p-value. The default is 1/R.}

\item{adjust.method}{Adjustment of p-values for multiple comparisons using \code{p.adjust}. The default is "none", in which case the p-values aren't adjusted. The other options are "holm", "hochberg", "hommel", "bonferroni", "BH", "BY", and "fdr"; see \code{?p.adjust} for details on these methods.}

\item{...}{Additional arguments passed to \code{censboot}, such as \code{parallel} for parallel computations. See \code{?boot::censboot} for details.}
}
\value{
A data frame containing coefficient estimates, bootstrap confidence intervals, and bootstrap p-values.
}
\description{
Summaries for Cox proportional hazards and accelerated failure time models, using the bootstrap for p-values and confidence intervals.
}
\details{
p-values can be computed by inverting the corresponding confidence intervals, as described in Section 14.2 of Thulin (2024) and Section 3.12 in Hall (1992). This function computes p-values in this way from "coxph" or "survreg" objects. The approach relies on the fact that:
\itemize{
\item the p-value of the two-sided test for the parameter theta is the smallest alpha such that theta is not contained in the corresponding 1-alpha confidence interval,
\item for a test of the parameter theta with significance level alpha, the set of values of theta that aren't rejected by the two-sided test (when used as the null hypothesis) is a 1-alpha confidence interval for theta.
}
}
\examples{
library(survival)
# Weibull AFT model:
# Note that model = TRUE is required for use with censboot_summary:
model <- survreg(formula = Surv(time, status) ~ age + sex, data = lung,
                 dist = "weibull", model = TRUE)
censboot_summary(model, R = 99)
# (Values for R greater than 99 are recommended for most applications.)

# Cox PH model:
model <- coxph(formula = Surv(time, status) ~ age + sex, data = lung,
               model = TRUE)
# Table with hazard ratios:
censboot_summary(model, R = 99)
censboot_summary(model, coef = "raw", R = 99)
}
\references{
\insertRef{hall92}{boot.pval}
\insertRef{thulin21}{boot.pval}
}
