% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.summary.R
\name{network.forest.plot}
\alias{network.forest.plot}
\title{Draws forest plot}
\usage{
network.forest.plot(
  result,
  level = 0.95,
  ticks.position = NULL,
  label.multiplier = 0.2,
  label.margin = 10,
  title = "Network Meta-analysis Forest plot",
  only.reference.treatment = FALSE
)
}
\arguments{
\item{result}{Object created by \code{\link{network.run}} function}

\item{level}{Confidence level. Default is 0.95 denoting 95 percent C.I.}

\item{ticks.position}{Position of the x-axis tick marks. If left unspecified, the function tries to set it at sensible values}

\item{label.multiplier}{This is a multiplying factor to move the position of the text associated with median[lower, upper] values. This number is multiplied by the range of x-axis and added to the x-axis limit. Default multiplier is set to 0.2.}

\item{label.margin}{This is how much margin space you specify to assign space for the median[lower, upper] values. Default margin is set to 10.}

\item{title}{Header name which you can modify}

\item{only.reference.treatment}{Indicator for plotting only the comparison to the reference treatment}
}
\value{
None
}
\description{
Draws forest plot of pooled treatment effect. Reports odds ratio for binomial and multinomial outcomes and continuous scale for normal outcomes.
}
\examples{
network <- with(certolizumab, {
 network.data(Outcomes, Study, Treat, N=N, response="binomial", Treat.order,
 covariate = covariate, covariate.type = "continuous", hy.prior = list("dhnorm", 0, 9.77))
})
\donttest{
result <- network.run(network)
network.forest.plot(result)
}
}
\references{
W. Viechtbauer (2010), \emph{Conducting meta-analyses in R with the metafor package}, Journal of Statistical Software, 36(3):1-48. \doi{10.18637/jss.v036.i03}
}
