// Generated by rstantools.  Do not edit by hand.

/*
    bmstdr is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    bmstdr is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with bmstdr.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_spatial_model_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 46> locations_array__ =
  {" (found before start of program)",
  " (in 'spatial_model', line 20, column 2 to column 17)",
  " (in 'spatial_model', line 21, column 2 to column 25)",
  " (in 'spatial_model', line 22, column 2 to column 16)",
  " (in 'spatial_model', line 23, column 2 to column 23)",
  " (in 'spatial_model', line 27, column 7 to column 8)",
  " (in 'spatial_model', line 27, column 0 to column 18)",
  " (in 'spatial_model', line 28, column 7 to column 8)",
  " (in 'spatial_model', line 28, column 0 to column 15)",
  " (in 'spatial_model', line 29, column 7 to column 8)",
  " (in 'spatial_model', line 29, column 10 to column 11)",
  " (in 'spatial_model', line 29, column 0 to column 15)",
  " (in 'spatial_model', line 30, column 7 to column 8)",
  " (in 'spatial_model', line 30, column 10 to column 11)",
  " (in 'spatial_model', line 30, column 0 to column 19)",
  " (in 'spatial_model', line 31, column 0 to column 7)",
  " (in 'spatial_model', line 34, column 0 to column 19)",
  " (in 'spatial_model', line 37, column 5 to column 54)",
  " (in 'spatial_model', line 36, column 18 to line 38, column 4)",
  " (in 'spatial_model', line 36, column 3 to line 38, column 4)",
  " (in 'spatial_model', line 39, column 4 to column 38)",
  " (in 'spatial_model', line 35, column 16 to line 40, column 3)",
  " (in 'spatial_model', line 35, column 1 to line 40, column 3)",
  " (in 'spatial_model', line 41, column 1 to column 31)",
  " (in 'spatial_model', line 43, column 1 to column 40)",
  " (in 'spatial_model', line 44, column 1 to column 54)",
  " (in 'spatial_model', line 45, column 1 to column 48)",
  " (in 'spatial_model', line 47, column 1 to column 39)",
  " (in 'spatial_model', line 4, column 0 to column 15)",
  " (in 'spatial_model', line 5, column 0 to column 15)",
  " (in 'spatial_model', line 6, column 7 to column 8)",
  " (in 'spatial_model', line 6, column 0 to column 12)",
  " (in 'spatial_model', line 7, column 7 to column 8)",
  " (in 'spatial_model', line 7, column 10 to column 11)",
  " (in 'spatial_model', line 7, column 0 to column 15)",
  " (in 'spatial_model', line 8, column 7 to column 8)",
  " (in 'spatial_model', line 8, column 10 to column 11)",
  " (in 'spatial_model', line 8, column 0 to column 18)",
  " (in 'spatial_model', line 9, column 0 to column 24)",
  " (in 'spatial_model', line 10, column 0 to column 31)",
  " (in 'spatial_model', line 11, column 0 to column 29)",
  " (in 'spatial_model', line 15, column 2 to column 18)",
  " (in 'spatial_model', line 16, column 9 to column 10)",
  " (in 'spatial_model', line 16, column 2 to column 36)",
  " (in 'spatial_model', line 20, column 9 to column 10)",
  " (in 'spatial_model', line 22, column 9 to column 10)"};
#include <stan_meta_header.hpp>
class model_spatial_model final : public model_base_crtp<model_spatial_model> {
private:
  int n;
  int p;
  Eigen::Matrix<double,-1,1> y_data__;
  Eigen::Matrix<double,-1,-1> X_data__;
  Eigen::Matrix<double,-1,-1> dist_data__;
  double phi;
  Eigen::Matrix<double,-1,1> priorsigma2_data__;
  Eigen::Matrix<double,-1,1> priortau2_data__;
  double delta;
  Eigen::Matrix<double,-1,1> mu_0_data__;
  Eigen::Map<Eigen::Matrix<double,-1,1>> y{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> X{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> dist{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> priorsigma2{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> priortau2{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> mu_0{nullptr, 0};
public:
  ~model_spatial_model() {}
  model_spatial_model(stan::io::var_context& context__, unsigned int
                      random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_spatial_model_namespace::model_spatial_model";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 28;
      context__.validate_dims("data initialization", "n", "int",
        std::vector<size_t>{});
      n = std::numeric_limits<int>::min();
      current_statement__ = 28;
      n = context__.vals_i("n")[(1 - 1)];
      current_statement__ = 28;
      stan::math::check_greater_or_equal(function__, "n", n, 0);
      current_statement__ = 29;
      context__.validate_dims("data initialization", "p", "int",
        std::vector<size_t>{});
      p = std::numeric_limits<int>::min();
      current_statement__ = 29;
      p = context__.vals_i("p")[(1 - 1)];
      current_statement__ = 29;
      stan::math::check_greater_or_equal(function__, "p", p, 0);
      current_statement__ = 30;
      stan::math::validate_non_negative_index("y", "n", n);
      current_statement__ = 31;
      context__.validate_dims("data initialization", "y", "double",
        std::vector<size_t>{static_cast<size_t>(n)});
      y_data__ = Eigen::Matrix<double,-1,1>::Constant(n,
                   std::numeric_limits<double>::quiet_NaN());
      new (&y) Eigen::Map<Eigen::Matrix<double,-1,1>>(y_data__.data(), n);
      {
        std::vector<local_scalar_t__> y_flat__;
        current_statement__ = 31;
        y_flat__ = context__.vals_r("y");
        current_statement__ = 31;
        pos__ = 1;
        current_statement__ = 31;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 31;
          stan::model::assign(y, y_flat__[(pos__ - 1)],
            "assigning variable y", stan::model::index_uni(sym1__));
          current_statement__ = 31;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 32;
      stan::math::validate_non_negative_index("X", "n", n);
      current_statement__ = 33;
      stan::math::validate_non_negative_index("X", "p", p);
      current_statement__ = 34;
      context__.validate_dims("data initialization", "X", "double",
        std::vector<size_t>{static_cast<size_t>(n), static_cast<size_t>(p)});
      X_data__ = Eigen::Matrix<double,-1,-1>::Constant(n, p,
                   std::numeric_limits<double>::quiet_NaN());
      new (&X) Eigen::Map<Eigen::Matrix<double,-1,-1>>(X_data__.data(), n, p);
      {
        std::vector<local_scalar_t__> X_flat__;
        current_statement__ = 34;
        X_flat__ = context__.vals_r("X");
        current_statement__ = 34;
        pos__ = 1;
        current_statement__ = 34;
        for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
          current_statement__ = 34;
          for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
            current_statement__ = 34;
            stan::model::assign(X, X_flat__[(pos__ - 1)],
              "assigning variable X", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 34;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 35;
      stan::math::validate_non_negative_index("dist", "n", n);
      current_statement__ = 36;
      stan::math::validate_non_negative_index("dist", "n", n);
      current_statement__ = 37;
      context__.validate_dims("data initialization", "dist", "double",
        std::vector<size_t>{static_cast<size_t>(n), static_cast<size_t>(n)});
      dist_data__ = Eigen::Matrix<double,-1,-1>::Constant(n, n,
                      std::numeric_limits<double>::quiet_NaN());
      new (&dist) Eigen::Map<Eigen::Matrix<double,-1,-1>>(dist_data__.data(),
        n, n);
      {
        std::vector<local_scalar_t__> dist_flat__;
        current_statement__ = 37;
        dist_flat__ = context__.vals_r("dist");
        current_statement__ = 37;
        pos__ = 1;
        current_statement__ = 37;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 37;
          for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
            current_statement__ = 37;
            stan::model::assign(dist, dist_flat__[(pos__ - 1)],
              "assigning variable dist", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 37;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 38;
      context__.validate_dims("data initialization", "phi", "double",
        std::vector<size_t>{});
      phi = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 38;
      phi = context__.vals_r("phi")[(1 - 1)];
      current_statement__ = 38;
      stan::math::check_greater_or_equal(function__, "phi", phi, 0.00001);
      current_statement__ = 39;
      context__.validate_dims("data initialization", "priorsigma2", "double",
        std::vector<size_t>{static_cast<size_t>(2)});
      priorsigma2_data__ = Eigen::Matrix<double,-1,1>::Constant(2,
                             std::numeric_limits<double>::quiet_NaN());
      new (&priorsigma2)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(priorsigma2_data__.data(), 2);
      {
        std::vector<local_scalar_t__> priorsigma2_flat__;
        current_statement__ = 39;
        priorsigma2_flat__ = context__.vals_r("priorsigma2");
        current_statement__ = 39;
        pos__ = 1;
        current_statement__ = 39;
        for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
          current_statement__ = 39;
          stan::model::assign(priorsigma2, priorsigma2_flat__[(pos__ - 1)],
            "assigning variable priorsigma2", stan::model::index_uni(sym1__));
          current_statement__ = 39;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 39;
      stan::math::check_greater_or_equal(function__, "priorsigma2",
        priorsigma2, 0);
      current_statement__ = 40;
      context__.validate_dims("data initialization", "priortau2", "double",
        std::vector<size_t>{static_cast<size_t>(2)});
      priortau2_data__ = Eigen::Matrix<double,-1,1>::Constant(2,
                           std::numeric_limits<double>::quiet_NaN());
      new (&priortau2)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(priortau2_data__.data(), 2);
      {
        std::vector<local_scalar_t__> priortau2_flat__;
        current_statement__ = 40;
        priortau2_flat__ = context__.vals_r("priortau2");
        current_statement__ = 40;
        pos__ = 1;
        current_statement__ = 40;
        for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
          current_statement__ = 40;
          stan::model::assign(priortau2, priortau2_flat__[(pos__ - 1)],
            "assigning variable priortau2", stan::model::index_uni(sym1__));
          current_statement__ = 40;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 40;
      stan::math::check_greater_or_equal(function__, "priortau2", priortau2,
        0);
      current_statement__ = 41;
      delta = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 41;
      delta = 1e-5;
      current_statement__ = 42;
      stan::math::validate_non_negative_index("mu_0", "n", n);
      current_statement__ = 43;
      mu_0_data__ = Eigen::Matrix<double,-1,1>::Constant(n,
                      std::numeric_limits<double>::quiet_NaN());
      new (&mu_0) Eigen::Map<Eigen::Matrix<double,-1,1>>(mu_0_data__.data(),
        n);
      current_statement__ = 43;
      stan::model::assign(mu_0, stan::math::rep_vector(0, n),
        "assigning variable mu_0");
      current_statement__ = 44;
      stan::math::validate_non_negative_index("beta", "p", p);
      current_statement__ = 45;
      stan::math::validate_non_negative_index("eta", "n", n);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = p + 1 + n + 1;
  }
  inline std::string model_name() const final {
    return "model_spatial_model";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_spatial_model_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<local_scalar_t__,-1,1> beta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(p, DUMMY_VAR__);
      current_statement__ = 1;
      beta = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(p);
      local_scalar_t__ sigma_sq = DUMMY_VAR__;
      current_statement__ = 2;
      sigma_sq = in__.template read_constrain_lb<local_scalar_t__,
                   jacobian__>(0, lp__);
      Eigen::Matrix<local_scalar_t__,-1,1> eta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
      current_statement__ = 3;
      eta = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(n);
      local_scalar_t__ tau_sq = DUMMY_VAR__;
      current_statement__ = 4;
      tau_sq = in__.template read_constrain_lb<local_scalar_t__,
                 jacobian__>(0, lp__);
      {
        current_statement__ = 5;
        stan::math::validate_non_negative_index("xbmodel", "n", n);
        Eigen::Matrix<local_scalar_t__,-1,1> xbmodel =
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
        current_statement__ = 7;
        stan::math::validate_non_negative_index("dats", "n", n);
        Eigen::Matrix<local_scalar_t__,-1,1> dats =
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
        current_statement__ = 9;
        stan::math::validate_non_negative_index("L", "n", n);
        current_statement__ = 10;
        stan::math::validate_non_negative_index("L", "n", n);
        Eigen::Matrix<local_scalar_t__,-1,-1> L =
          Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(n, n, DUMMY_VAR__);
        current_statement__ = 12;
        stan::math::validate_non_negative_index("Sigma", "n", n);
        current_statement__ = 13;
        stan::math::validate_non_negative_index("Sigma", "n", n);
        Eigen::Matrix<local_scalar_t__,-1,-1> Sigma =
          Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(n, n, DUMMY_VAR__);
        local_scalar_t__ u = DUMMY_VAR__;
        current_statement__ = 16;
        stan::model::assign(xbmodel, stan::math::multiply(X, beta),
          "assigning variable xbmodel");
        current_statement__ = 22;
        for (int i = 1; i <= n; ++i) {
          current_statement__ = 19;
          for (int j = 1; j <= n; ++j) {
            current_statement__ = 17;
            stan::model::assign(Sigma, (sigma_sq *
              stan::math::exp(((-1 * phi) *
                stan::model::rvalue(dist, "dist", stan::model::index_uni(i),
                  stan::model::index_uni(j))))), "assigning variable Sigma",
              stan::model::index_uni(i), stan::model::index_uni(j));
          }
          current_statement__ = 20;
          stan::model::assign(Sigma,
            (stan::model::rvalue(Sigma, "Sigma", stan::model::index_uni(i),
               stan::model::index_uni(i)) + delta),
            "assigning variable Sigma", stan::model::index_uni(i),
            stan::model::index_uni(i));
        }
        current_statement__ = 23;
        stan::model::assign(L, stan::math::cholesky_decompose(Sigma),
          "assigning variable L");
        current_statement__ = 24;
        lp_accum__.add(stan::math::multi_normal_cholesky_lpdf<propto__>(eta,
                         mu_0, L));
        current_statement__ = 25;
        lp_accum__.add(stan::math::inv_gamma_lpdf<propto__>(sigma_sq,
                         stan::model::rvalue(priorsigma2, "priorsigma2",
                           stan::model::index_uni(1)),
                         stan::model::rvalue(priorsigma2, "priorsigma2",
                           stan::model::index_uni(2))));
        current_statement__ = 26;
        lp_accum__.add(stan::math::inv_gamma_lpdf<propto__>(tau_sq,
                         stan::model::rvalue(priortau2, "priortau2",
                           stan::model::index_uni(1)),
                         stan::model::rvalue(priortau2, "priortau2",
                           stan::model::index_uni(2))));
        current_statement__ = 27;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(y,
                         stan::math::add(xbmodel, eta),
                         stan::math::sqrt(tau_sq)));
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_spatial_model_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<double,-1,1> beta =
        Eigen::Matrix<double,-1,1>::Constant(p,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 1;
      beta = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(p);
      double sigma_sq = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 2;
      sigma_sq = in__.template read_constrain_lb<local_scalar_t__,
                   jacobian__>(0, lp__);
      Eigen::Matrix<double,-1,1> eta =
        Eigen::Matrix<double,-1,1>::Constant(n,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 3;
      eta = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(n);
      double tau_sq = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 4;
      tau_sq = in__.template read_constrain_lb<local_scalar_t__,
                 jacobian__>(0, lp__);
      out__.write(beta);
      out__.write(sigma_sq);
      out__.write(eta);
      out__.write(tau_sq);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> beta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(p, DUMMY_VAR__);
      current_statement__ = 1;
      stan::model::assign(beta,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(p),
        "assigning variable beta");
      out__.write(beta);
      local_scalar_t__ sigma_sq = DUMMY_VAR__;
      current_statement__ = 2;
      sigma_sq = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, sigma_sq);
      Eigen::Matrix<local_scalar_t__,-1,1> eta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
      current_statement__ = 3;
      stan::model::assign(eta,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(n),
        "assigning variable eta");
      out__.write(eta);
      local_scalar_t__ tau_sq = DUMMY_VAR__;
      current_statement__ = 4;
      tau_sq = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, tau_sq);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "beta", "double",
        std::vector<size_t>{static_cast<size_t>(p)});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "sigma_sq",
        "double", std::vector<size_t>{});
      current_statement__ = 3;
      context__.validate_dims("parameter initialization", "eta", "double",
        std::vector<size_t>{static_cast<size_t>(n)});
      current_statement__ = 4;
      context__.validate_dims("parameter initialization", "tau_sq", "double",
        std::vector<size_t>{});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> beta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(p, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> beta_flat__;
        current_statement__ = 1;
        beta_flat__ = context__.vals_r("beta");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
          current_statement__ = 1;
          stan::model::assign(beta, beta_flat__[(pos__ - 1)],
            "assigning variable beta", stan::model::index_uni(sym1__));
          current_statement__ = 1;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(beta);
      local_scalar_t__ sigma_sq = DUMMY_VAR__;
      current_statement__ = 2;
      sigma_sq = context__.vals_r("sigma_sq")[(1 - 1)];
      out__.write_free_lb(0, sigma_sq);
      Eigen::Matrix<local_scalar_t__,-1,1> eta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> eta_flat__;
        current_statement__ = 3;
        eta_flat__ = context__.vals_r("eta");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 3;
          stan::model::assign(eta, eta_flat__[(pos__ - 1)],
            "assigning variable eta", stan::model::index_uni(sym1__));
          current_statement__ = 3;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(eta);
      local_scalar_t__ tau_sq = DUMMY_VAR__;
      current_statement__ = 4;
      tau_sq = context__.vals_r("tau_sq")[(1 - 1)];
      out__.write_free_lb(0, tau_sq);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"beta", "sigma_sq", "eta", "tau_sq"};
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {}
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{static_cast<
                                                                    size_t>(p)},
                std::vector<size_t>{},
                std::vector<size_t>{static_cast<size_t>(n)},
                std::vector<size_t>{}};
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {}
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
      param_names__.emplace_back(std::string() + "beta" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "sigma_sq");
    for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
      param_names__.emplace_back(std::string() + "eta" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "tau_sq");
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {}
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
      param_names__.emplace_back(std::string() + "beta" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "sigma_sq");
    for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
      param_names__.emplace_back(std::string() + "eta" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "tau_sq");
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {}
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(p) + "},\"block\":\"parameters\"},{\"name\":\"sigma_sq\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"eta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n) + "},\"block\":\"parameters\"},{\"name\":\"tau_sq\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(p) + "},\"block\":\"parameters\"},{\"name\":\"sigma_sq\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"eta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n) + "},\"block\":\"parameters\"},{\"name\":\"tau_sq\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (((p + 1) + n) + 1);
    const size_t num_transformed = emit_transformed_parameters * (0);
    const size_t num_gen_quantities = emit_generated_quantities * (0);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (((p + 1) + n) + 1);
    const size_t num_transformed = emit_transformed_parameters * (0);
    const size_t num_gen_quantities = emit_generated_quantities * (0);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_spatial_model_namespace::model_spatial_model;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_spatial_model_namespace::profiles__;
}
#endif
#endif
