% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bexy.R
\name{plotCounts}
\alias{plotCounts}
\title{Plotting the percentage of counts mapping to two scaffolds (by default a Y-linked scaffold against a X-linked scaffold), colored by sex karyotype}
\usage{
plotCounts(
  x,
  scaffoldX = NULL,
  scaffoldY = NULL,
  colors = c("turquoise3", "darkorange", "royalblue4"),
  sampleNamesToHighlight = c(),
  label = TRUE,
  ...
)
}
\arguments{
\item{x}{A bexy object.}

\item{scaffoldX}{A string with the name of the scaffold to be plotted on the x-axis. If NULL (default), a X-linked scaffold is used.}

\item{scaffoldY}{A string with the name of the scaffold to be plotted on the y-axis. If NULL (default), a Y-linked scaffold is used.}

\item{colors}{A vector of length three with the colors for aneuploid, XX and XY samples, respectively.}

\item{sampleNamesToHighlight}{A vector of sample names that should be highlighted. If empty, samples are automatically highlighted based on the posterior probabilities.}

\item{label}{Boolean indicating whether samples should be labeled.}

\item{...}{Other parameters used for plotting.}
}
\value{
No return value, called for side effects.
}
\description{
Plotting the percentage of counts mapping to two scaffolds (by default a Y-linked scaffold against a X-linked scaffold), colored by sex karyotype
}
\examples{
bex <- bexy()
plotCounts(bex)
}
\seealso{
\code{\link{bexy}}
}
