% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/30_zShortingCommodityFuturePnL.R
\name{zShortingCommodityFuture}
\alias{zShortingCommodityFuture}
\title{Calculates Profit and Loss at expiration for Shorting a Commodity Future (per unit of the underlying commodity) and draws its graph in the Plots tab.}
\usage{
zShortingCommodityFuture(
  STF,
  F0,
  C,
  hl = 0.985,
  hu = 1.005,
  xlab = "Commodity Price ($) at Offset",
  ylab = " Profit / Loss [PnL] at Offset ($)",
  main = "Shorting a Commodity Future [ PnL]"
)
}
\arguments{
\item{STF}{Commodity price at time T.}

\item{F0}{Commodity Initial Price .}

\item{C}{Cost involved in establishing Future Contract.}

\item{hl}{lower bound value for setting lower-limit of x-axis displaying spot price.}

\item{hu}{upper bound value for setting upper-limit of x-axis displaying spot price.}

\item{xlab}{X-axis label.}

\item{ylab}{Y-axis label.}

\item{main}{Title of the Graph.}
}
\value{
Returns a graph of the strategy.
}
\description{
On initiation, this is a net credit Strategy and results in net cash inflow in the form of receiving the price of Future contract (per unit of the underlying). At the time of offset the trader or investor has to buy the underlying commodity of future contract at the price on the day of offset. If the bearish outlook of the trader holds good and the price of the commodity (underlying) falls then the trader makes the profit as shown in the graph (TD Ameritrade, 2019).
}
\details{
According to the information provided by TD Ameritrade (2019), this method is developed, and the given examples are created to compute Profit and Loss at expiration for Shorting a Commodity Future (per unit of the underlying commodity) and draws its graph in the Plots tab.
}
\examples{
zShortingCommodityFuture(430,430,0)
zShortingCommodityFuture(2900,2910,0,hl=0.9995,hu=1.005)
}
\references{
TD Ameritrade. (2019, July 26). Micro E-Mini Futures Contracts. YouTube.https://youtu.be/SShGjJepCdA\cr
Hull, J. C. (2022). Options, Futures, and Other Derivatives (11th ed.). Pearson Education (US). https://bookshelf.vitalsource.com/books/9780136940043
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
