% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdsvd.R
\name{detect.blocks}
\alias{detect.blocks}
\title{Block Detection}
\usage{
detect.blocks(V, threshold = 0)
}
\arguments{
\item{V}{Numeric matrix which either contains the loadings or is a covariance matrix.}

\item{threshold}{All absolute values of \code{V} below the threshold are set to zero.}
}
\value{
An object of class \code{Block} containing the features and columns indices corresponding to each detected block.
}
\description{
This function returns the block structure of a matrix.
}
\examples{
#In the first example, we replicate the simulation study for the ad hoc procedure
#Est_0.1 from Bauer (2024). In the second example, we manually compute the first step
#of BD-SVD, which can be done using the bdsvd() and/or single.bdsvd(), for constructed
#sparse loadings

#Example 1: Replicate the simulation study (a) from Bauer (2024) for the ad hoc
#procedure Est_0.1.

\dontrun{
p <- 500 #Number of variables
n <- 125 #Number of observations
b <- 500 #Number of blocks
design <- "a"

#Simulate data matrix X
set.seed(1)
Sigma <- bdsvd.cov.sim(p = p, b = b, design = design)
X <- mvtnorm::rmvnorm(n, mean=rep(0, p), sigma=Sigma)
colnames(X) <- 1:p

#Perform the ad hoc procedure
detect.blocks(cvCovEst::scadEst(dat = X, lambda = 0.2), threshold = 0)
}

#Example 2: Manually compute the first step of BD-SVD
#for some loadings V that mirror the two blocks
#("A", "B") and c("C", "D").

V <- matrix(c(1,0,
              1,0,
              0,1,
              0,1), 4, 2, byrow = TRUE)

rownames(V) <- c("A", "B", "C", "D")
detected.blocks <- detect.blocks(V)

#Variables in block one with corresponding column index:
detected.blocks[[1]]@features
detected.blocks[[1]]@block.columns

#Variables in block two with corresponding column index:
detected.blocks[[2]]@features
detected.blocks[[2]]@block.columns

}
\references{
\cite{Bauer, J.O. (2024). High-dimensional block diagonal covariance structure detection using singular vectors, J. Comput. Graph. Stat.}
}
\seealso{
\code{\link{bdsvd}}, \code{\link{single.bdsvd}}
}
