% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DynamicPipeline.R
\name{DynamicPipeline}
\alias{DynamicPipeline}
\title{Class implementing a dynamic pipelining process}
\description{
This \code{\link{DynamicPipeline}} class inherits from the
\code{\link{GenericPipeline}} class. Includes the \strong{execute} method
which provides a dynamic pipelining implementation.
'
}
\section{Inherit}{

This class inherits from \code{\link{GenericPipeline}} and implements the
\code{execute} abstract function.
}

\seealso{
\code{\link{bdpar.log}}, \code{\link{Instance}},
         \code{\link{DefaultPipeline}}, \code{\link{GenericPipeline}},
         \code{\link{GenericPipe}}, \code{\link{\%>|\%}}
}
\section{Super class}{
\code{\link[bdpar:GenericPipeline]{bdpar::GenericPipeline}} -> \code{DynamicPipeline}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DynamicPipeline-new}{\code{DynamicPipeline$new()}}
\item \href{#method-DynamicPipeline-add}{\code{DynamicPipeline$add()}}
\item \href{#method-DynamicPipeline-removeByPos}{\code{DynamicPipeline$removeByPos()}}
\item \href{#method-DynamicPipeline-removeByPipe}{\code{DynamicPipeline$removeByPipe()}}
\item \href{#method-DynamicPipeline-removeAll}{\code{DynamicPipeline$removeAll()}}
\item \href{#method-DynamicPipeline-execute}{\code{DynamicPipeline$execute()}}
\item \href{#method-DynamicPipeline-get}{\code{DynamicPipeline$get()}}
\item \href{#method-DynamicPipeline-print}{\code{DynamicPipeline$print()}}
\item \href{#method-DynamicPipeline-toString}{\code{DynamicPipeline$toString()}}
\item \href{#method-DynamicPipeline-clone}{\code{DynamicPipeline$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DynamicPipeline-new"></a>}}
\if{latex}{\out{\hypertarget{method-DynamicPipeline-new}{}}}
\subsection{Method \code{new()}}{
Creates a \code{\link{DynamicPipeline}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DynamicPipeline$new(pipeline = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pipeline}}{A \code{\link{list}} of \code{\link{GenericPipe}}
objects. Initializes the flow of \code{\link{GenericPipe}}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DynamicPipeline-add"></a>}}
\if{latex}{\out{\hypertarget{method-DynamicPipeline-add}{}}}
\subsection{Method \code{add()}}{
Adds a \code{\link{GenericPipe}} or a
\code{\link{GenericPipe}} list to the pipeline.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DynamicPipeline$add(pipe, pos = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pipe}}{A \code{\link{GenericPipe}} object or a \code{\link{list}} of
\code{\link{GenericPipe}} objects.}

\item{\code{pos}}{A (\emph{numeric}) value. The value of the position to add.
If it is NULL, \code{\link{GenericPipe}} is appended to the pipeline.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DynamicPipeline-removeByPos"></a>}}
\if{latex}{\out{\hypertarget{method-DynamicPipeline-removeByPos}{}}}
\subsection{Method \code{removeByPos()}}{
Removes \code{\link{GenericPipe}s} by the position on the
pipeline.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DynamicPipeline$removeByPos(pos)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pos}}{A (\emph{numeric}) value. The value of the position to remove.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DynamicPipeline-removeByPipe"></a>}}
\if{latex}{\out{\hypertarget{method-DynamicPipeline-removeByPipe}{}}}
\subsection{Method \code{removeByPipe()}}{
Removes \code{\link{GenericPipe}s} by its name on the
pipeline.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DynamicPipeline$removeByPipe(pipe.name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pipe.name}}{A (\emph{character}) value. The
\code{\link{GenericPipe}s} name to remove.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DynamicPipeline-removeAll"></a>}}
\if{latex}{\out{\hypertarget{method-DynamicPipeline-removeAll}{}}}
\subsection{Method \code{removeAll()}}{
Removes all \code{\link{GenericPipe}s} included on pipeline.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DynamicPipeline$removeAll()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DynamicPipeline-execute"></a>}}
\if{latex}{\out{\hypertarget{method-DynamicPipeline-execute}{}}}
\subsection{Method \code{execute()}}{
Function where is implemented the flow of the
\code{\link{GenericPipe}s}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DynamicPipeline$execute(instance)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{instance}}{A (\emph{Instance}) value. The \code{\link{Instance}}
that is going to be processed.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DynamicPipeline-get"></a>}}
\if{latex}{\out{\hypertarget{method-DynamicPipeline-get}{}}}
\subsection{Method \code{get()}}{
Gets a list with containing the set of \code{\link{GenericPipe}s}
of the pipeline.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DynamicPipeline$get()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The set of \code{\link{GenericPipe}s} containing the pipeline.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DynamicPipeline-print"></a>}}
\if{latex}{\out{\hypertarget{method-DynamicPipeline-print}{}}}
\subsection{Method \code{print()}}{
Prints pipeline representation. (Override print function)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DynamicPipeline$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Further arguments passed to or from other methods.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DynamicPipeline-toString"></a>}}
\if{latex}{\out{\hypertarget{method-DynamicPipeline-toString}{}}}
\subsection{Method \code{toString()}}{
Returns a \code{\link{character}} representing the pipeline
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DynamicPipeline$toString()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{\link{DynamicPipeline}} \code{\link{character}} representation
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DynamicPipeline-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DynamicPipeline-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DynamicPipeline$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
