% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FlexTableStyles.R
\docType{class}
\name{FlexTableStyles}
\alias{FlexTableStyles}
\title{R6 class that defines a collection of styles as used by the `flextable`
package.}
\format{
\code{\link[R6]{R6Class}} object.
}
\description{
The `FlexTableStyles` class stores a collection of `FlexTableStyle`
style objects.
}
\examples{
# This class should not be used by end users.  It is an internal class
# created only by the BasicTable class.  It is used when converting to a
# flextable.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{count}}{The number of styles in the collection.}

\item{\code{styles}}{A list of `FlexTableStyle` objects that comprise the collection.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FlexTableStyles-new}{\code{FlexTableStyles$new()}}
\item \href{#method-FlexTableStyles-clearStyles}{\code{FlexTableStyles$clearStyles()}}
\item \href{#method-FlexTableStyles-findNamedStyle}{\code{FlexTableStyles$findNamedStyle()}}
\item \href{#method-FlexTableStyles-findOrAddStyle}{\code{FlexTableStyles$findOrAddStyle()}}
\item \href{#method-FlexTableStyles-addNamedStyles}{\code{FlexTableStyles$addNamedStyles()}}
\item \href{#method-FlexTableStyles-asList}{\code{FlexTableStyles$asList()}}
\item \href{#method-FlexTableStyles-asJSON}{\code{FlexTableStyles$asJSON()}}
\item \href{#method-FlexTableStyles-asString}{\code{FlexTableStyles$asString()}}
\item \href{#method-FlexTableStyles-clone}{\code{FlexTableStyles$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FlexTableStyles-new"></a>}}
\if{latex}{\out{\hypertarget{method-FlexTableStyles-new}{}}}
\subsection{Method \code{new()}}{
Create a new `FlexTableStyles` object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FlexTableStyles$new(parentTable)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parentTable}}{Owning table.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FlexTableStyles-clearStyles"></a>}}
\if{latex}{\out{\hypertarget{method-FlexTableStyles-clearStyles}{}}}
\subsection{Method \code{clearStyles()}}{
Clear the collection removing all styles.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FlexTableStyles$clearStyles()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FlexTableStyles-findNamedStyle"></a>}}
\if{latex}{\out{\hypertarget{method-FlexTableStyles-findNamedStyle}{}}}
\subsection{Method \code{findNamedStyle()}}{
Find a style in the collection matching the specified base style name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FlexTableStyles$findNamedStyle(baseStyleName)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{baseStyleName}}{The style name to find.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A `TableTableFlexTbl` object that is the style matching the
  specified base style name or `NULL` otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FlexTableStyles-findOrAddStyle"></a>}}
\if{latex}{\out{\hypertarget{method-FlexTableStyles-findOrAddStyle}{}}}
\subsection{Method \code{findOrAddStyle()}}{
Find a style in the collection matching the specified base style name and
style properties.  If there is no matching style, then optionally add a
new style.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FlexTableStyles$findOrAddStyle(
  action = "findOrAdd",
  baseStyleName = NULL,
  isBaseStyle = NULL,
  style = NULL,
  mapFromCss = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{action}}{The action to carry out.  Must be one of "find", "add" or
"findOrAdd" (default).}

\item{\code{baseStyleName}}{The style name to find/add.}

\item{\code{isBaseStyle}}{Is the style to be found/added a base style?}

\item{\code{style}}{A `TableStyle` object specifying style properties to be found/added.}

\item{\code{mapFromCss}}{`TRUE` (default) to map the basictabler CSS styles to
corresponding flextable styles, `FALSE` to apply only the specified ft
styles.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A `TableTableFlexTbl` object that is the style matching the
  specified base style name or `NULL` otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FlexTableStyles-addNamedStyles"></a>}}
\if{latex}{\out{\hypertarget{method-FlexTableStyles-addNamedStyles}{}}}
\subsection{Method \code{addNamedStyles()}}{
Populate the FlexTbl styles
  based on the styles defined in the table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FlexTableStyles$addNamedStyles(mapFromCss = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mapFromCss}}{`TRUE` (default) to map the basictabler CSS styles to
corresponding Excel styles, `FALSE` to apply only the specified ft
styles.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FlexTableStyles-asList"></a>}}
\if{latex}{\out{\hypertarget{method-FlexTableStyles-asList}{}}}
\subsection{Method \code{asList()}}{
Return the contents of this object as a list for debugging.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FlexTableStyles$asList()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of various object properties.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FlexTableStyles-asJSON"></a>}}
\if{latex}{\out{\hypertarget{method-FlexTableStyles-asJSON}{}}}
\subsection{Method \code{asJSON()}}{
Return the contents of this object as JSON for debugging.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FlexTableStyles$asJSON()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A JSON representation of various object properties.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FlexTableStyles-asString"></a>}}
\if{latex}{\out{\hypertarget{method-FlexTableStyles-asString}{}}}
\subsection{Method \code{asString()}}{
Return the contents of this object as a string for debugging.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FlexTableStyles$asString(seperator = ", ")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{seperator}}{Delimiter used to combine multiple values into a string.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character representation of various object properties.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FlexTableStyles-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FlexTableStyles-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FlexTableStyles$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
