% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.r
\name{da_insert}
\alias{da_insert}
\title{Table Insertion with arcpy.da}
\usage{
da_insert(table.path, d)
}
\arguments{
\item{table.path}{The file path to the table.}

\item{d}{The data to write to \code{table.path}, with the same number
of rows as the table. Column names must match field names
of the table.}
}
\value{
(Invisible) The path to the table, i.e. \code{table.path}.
}
\description{
Insert records into a table (e.g. attribute table of a layer)
with the arcpy.da module.
}
\examples{
\dontrun{
arcpy$env$workspace = tempdir()
arcpy$env$scratchWorkspace = tempdir()
fc = arcpy$management$CopyFeatures(system.file("CA_Counties",
  "CA_Counties_TIGER2016.shp", package = "arcpy"), "CA_Counties")
d = da_read(fc, c("ALAND", "CLASSFP"))
add.d = data.frame(ALAND= 1e4, CLASSFP = "H2",
  stringsAsFactors = FALSE)
da_insert(fc, add.d)
}

}
