% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_descriptions.R
\docType{data}
\name{recovery_data}
\alias{recovery_data}
\title{Simulated recovery data}
\format{
An object of class \code{data.frame} with 120 rows and 10 columns.
}
\usage{
recovery_data
}
\value{
A dataframe
\describe{
\item{columns 1-2}{indicator variables identifying individuals
in the control treatment that died (control.d = 1)
or were censored (control.c = 1)}
\item{columns 3-4}{indicator variables identifying individuals
in the infected treatment that died (infected.d = 1)
or were censored (infected.c = 1) while still infected}
\item{columns 5-6}{indicator variables indenifying individuals
in the infected treatment that died (recovered.d = 1)
or were censored (recovered.c = 1) after recovering from infection}
\item{censor}{'0' not censored, '1' censored}
\item{d}{death indicator: '1' died, '0'}
\item{t}{time of the event (death or censoring)}
\item{fq}{frequence or number of individuals associated with the event
of death or censoring at time t}
}
}
\description{
Simulated data allowing for recovery from infection,
where recovered individuals experience the same background mortality
as uninfected individuals.
}
\examples{
head(recovery_data) ; tail(recovery_data)
}
\keyword{datasets}
