% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{etd_uninfected}
\alias{etd_uninfected}
\title{Expected time of death: uninfected hosts}
\usage{
etd_uninfected(a1, b1, d1 = "", tmax = 100)
}
\arguments{
\item{a1, b1}{location & scale parameters for background mortality}

\item{d1}{character: name of probability distribution describing
background mortality}

\item{tmax}{numeric. Maximum value of t for which expected time of death
is searched; defaults to 100. Minimum time is zero (0)}
}
\value{
numeric
}
\description{
Time when uninfected hosts are expected to have died due to their
cumulative exposure to background mortality.
}
\details{
It is the time t when, H1[t] = 1, and
cumulative survival is, S1[t] = exp(-1) = 0.367
}
\examples{
print(etd_uninfected(a1 = 2, b1 = 0.5, d1 = "Weibull")) # 7.38
print(etd_uninfected(a1 = 20, b1 = 5, d1 = "Gumbel")) # 20
print(etd_uninfected(a1 = 3, b1 = 0.6, d1 = "Frechet")) # 32.06
}
\seealso{
\code{\link{etd_infected}}
}
