% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{etd_infected}
\alias{etd_infected}
\title{Expected time of death: infected hosts}
\usage{
etd_infected(a1, b1, a2, b2, d1 = "", d2 = "", tmax = 100)
}
\arguments{
\item{a1, b1}{location & scale parameters for background mortality}

\item{a2, b2}{location & scale parameters for mortality due to infection}

\item{d1, d2}{character: name of probability distributions describing
background mortality and mortality due to infection, respectively}

\item{tmax}{numeric. Maximum value of t for which expected time of death
is searched; defaults to 100. Minimum time is zero (0)}
}
\value{
numeric
}
\description{
Time when infected hosts are expected to have died due to their cumulative
exposure to background mortality and mortality due to infection.
}
\details{
It is the time t when, H1[t] + H2[t] = 1,
and cumulative survival is, S1[t].S2[t] = exp(-1) = 0.367
}
\examples{
print(etd_infected(a1 = 2, b1 = 0.5, a2 = 30, b2 = 5,
                   d1 = "Weibull", d2 = "Gumbel")) # 7.34
print(etd_infected(a1 = 20, b1 = 5, a2 = 3, b2 = 0.6,
                   d1 = "Gumbel", d2 = "Frechet")) # 17.84
print(etd_infected(a1 = 3, b1 = 0.6, a2 = 2, b2 = 0.5,
                   d1 = "Frechet", d2 = "Weibull")) # 7.37
}
\seealso{
\code{\link{etd_uninfected}}
}
