% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATE.complete.R
\name{ATE.complete}
\alias{ATE.complete}
\title{ATE Deposition Summary}
\usage{
ATE.complete(filename, summaryOnly = FALSE)
}
\arguments{
\item{filename}{XML Status file from Angstrom Thermal Evaporator}

\item{summaryOnly}{logical, if \code{TRUE}, returns summary for one layer}
}
\value{
deposition thickness, rate, ramping times, and actions
}
\description{
Reads an XML Status file from the ATE thermal evaporator and returns
the procedural timeline.
}
\details{
Extracts information about the deposition thickness from the completed
status XML file at the end of the deposition.
}
\examples{
fileName <- ATE.sampleFiles('_Complete_')
ATE.complete(fileName, TRUE)
ATE.complete(fileName)

}
\author{
Thomas Gredig
}
