% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/altR2.R
\name{estimate_adj_R2}
\alias{estimate_adj_R2}
\title{Obtain estimates of the multiple squared correlation}
\usage{
estimate_adj_R2(Rsquared, N, p)
}
\arguments{
\item{Rsquared}{R-squared value}

\item{N}{Number of observations}

\item{p}{Number of predictors}
}
\value{
A named vector with the different estimates
}
\description{
Returns different estimates of the multiple squared correlation.
}
\examples{
## Annette Dobson (1990) "An Introduction to Generalized Linear Models".
## Page 9: Plant Weight Data.
ctl <- c(4.17, 5.58, 5.18, 6.11, 4.50, 4.61, 5.17, 4.53, 5.33, 5.14)
trt <- c(4.81, 4.17, 4.41, 3.59, 5.87, 3.83, 6.03, 4.89, 4.32, 4.69)
group <- gl(2, 10, 20, labels = c("Ctl", "Trt"))
weight <- c(ctl, trt)
lm.D9 <- lm(weight ~ group)
estimates <- estimate_adj_R2(summary(lm.D9)$r.squared, length(weight), 1)
}
