% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normal.r
\name{normal2d}
\alias{normal2d}
\alias{normal2d.Coord2D}
\alias{normal2d.Line2D}
\title{2D normal vectors}
\usage{
normal2d(x, ...)

\method{normal2d}{Coord2D}(x, ..., normalize = TRUE)

\method{normal2d}{Line2D}(x, ..., normalize = TRUE)
}
\arguments{
\item{x}{Object to compute a 2D normal vector for
such as a \link{Line2D} object.}

\item{...}{Passed to or from other methods.}

\item{normalize}{If \code{TRUE} coerce to a normalize vector}
}
\value{
A \link{Coord2D} (normal) vector
}
\description{
\code{normal2d()} is an S3 generic that computes a 2D normal vector.
}
\examples{
  p <- as_coord2d(x = 2, y = 3)
  normal2d(p)
  normal2d(p, normalize = FALSE)
}
