% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-aesops_bing.R
\docType{data}
\name{aesops_bing}
\alias{aesops_bing}
\title{Aesop's Fables Tokens with Bing Sentiment Labels}
\format{
A tibble with one row per token and sentiment match, containing:
\describe{
  \item{fable_id}{Character identifier for the fable}
  \item{title}{Title of the fable}
  \item{word}{Tokenized word from the fable text}
  \item{sentiment}{Binary sentiment label (\code{"positive"} or \code{"negative"})}
}
}
\source{
Bing Liu sentiment lexicon.
}
\usage{
data(aesops_bing)
}
\description{
A token-level dataset of Aesop's Fables joined with the Bing Liu sentiment
lexicon. Each row represents a word from a fable that appears in the
Bing lexicon, labeled with binary sentiment polarity.
}
\details{
The Bing lexicon classifies words as either \code{"positive"} or
\code{"negative"}, making this dataset useful for polarity-based
sentiment summaries and instructional demonstrations.
}
\references{
Hu, M., & Liu, B. (2004). *Mining and summarizing customer reviews*.
Proceedings of the ACM SIGKDD International Conference on Knowledge
Discovery and Data Mining.
}
\seealso{
\code{\link{aesops_tokens}}
}
\keyword{datasets}
