\name{alt.parallel}
\alias{alt.parallel}

\title{
    Modify an \code{"alt"} Object Establishing a Parallel Parametric Fit
}
\description{
    This function generates parameters for each applicable data set with the same log standard deviation or weibull slope. 
	}
\usage{alt.parallel(x, ignore_slope=0, set.exponential=FALSE, view_parallel_fits=TRUE)
	}

\arguments{
    \item{x}{
        An \code{"alt"} object as generated by \code{"alt.make"}.
	}
	\item{ignore_slope}{
		An optional vector listing any data set(s) that judged to be excluded from parallel parameter determination. 
	}
	\item{set.exponential}{
		A logical used to establish an exponential assumption for the provided life data.
	}
	\item{view_parallel_fits}{
		A logical defining whether to generate a probability plot of the parallelized fits on the input data objects.
	}
}

\details{
	A probability plot view of the data sets will be generated by default permitting a view of the 
	parallelized parametric fitting. 
	
	The returned object can be plotted using S3 function \code{"plot.alt"} placing the failure points (taking intervals 
	as mean time points) in accordance with theas specified alt.model relationship. By using the is.plot.fit_points an
	marker will be overlayed defining the median or characteristic life estimate for each set.
}

\value{
	The	input object will be returned with the addition of a \code{"$parallel_par"} element.	
}

\references{

  Wayne Nelson, (1990) "Accelerated Testing", Wiley-Interscience, New York
  
  William Q. Meeker and Luis A. Escobar, (1998) "Statistical Methods for Reliability Data", Wiley-Interscience, New York
  
  Pascual F., Meeker W., Escobar L. (2006) Accelerated Life Test Models and Data Analysis. In: Pham H. (eds) Springer Handbook of Engineering Statistics. Springer Handbooks. Springer, London. https://doi.org/10.1007/978-1-84628-288-1_22
}
